/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.handler.PasswordCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.OTPCredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.credential.util.TimeBasedOTP;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={TOTPCredentials.class, TOTPCredential.class}, credentialStorage=OTPCredentialStorage.class)
public class TOTPCredentialHandler
extends PasswordCredentialHandler<CredentialStore<?>, TOTPCredentials, TOTPCredential> {
    public static final String ALGORITHM = "ALGORITHM";
    public static final String INTERVAL_SECONDS = "INTERVAL_SECONDS";
    public static final String NUMBER_DIGITS = "NUMBER_DIGITS";
    public static final String DELAY_WINDOW = "DELAY_WINDOW";
    public static final String DEFAULT_DEVICE = "DEFAULT_DEVICE";
    private TimeBasedOTP totp;

    @Override
    public void setup(CredentialStore<?> store) {
        super.setup(store);
        String algorithm = this.getConfigurationProperty(store, ALGORITHM, "HmacSHA1");
        String intervalSeconds = this.getConfigurationProperty(store, INTERVAL_SECONDS, "30");
        String numberDigits = this.getConfigurationProperty(store, NUMBER_DIGITS, "6");
        String delayWindow = this.getConfigurationProperty(store, DELAY_WINDOW, "1");
        this.totp = new TimeBasedOTP(algorithm, Integer.parseInt(numberDigits), Integer.valueOf(intervalSeconds), Integer.valueOf(delayWindow));
    }

    @Override
    public void validate(IdentityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        super.validate(context, credentials, store);
        if ((Credentials.Status.VALID.equals((Object)credentials.getStatus()) || Credentials.Status.EXPIRED.equals((Object)credentials.getStatus())) && !this.isValid(context, credentials, store)) {
            credentials.setStatus(Credentials.Status.INVALID);
            credentials.setValidatedAccount(null);
        }
    }

    @Override
    public void update(IdentityContext context, Account account, TOTPCredential credential, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (credential.getValue() != null && credential.getValue().length > 0) {
            super.update(context, account, credential, store, effectiveDate, expiryDate);
        }
        OTPCredentialStorage storage = new OTPCredentialStorage();
        if (effectiveDate != null) {
            storage.setEffectiveDate(effectiveDate);
        }
        storage.setExpiryDate(expiryDate);
        storage.setSecretKey(credential.getSecret());
        storage.setDevice(this.getDevice(credential.getDevice()));
        store.storeCredential(context, account, storage);
    }

    private boolean isValid(IdentityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        for (OTPCredentialStorage storage : this.getCredentialStorages(context, credentials, store)) {
            String secretKey = storage.getSecretKey();
            String token = credentials.getToken();
            if (!this.totp.validate(token, secretKey.getBytes())) continue;
            return true;
        }
        return false;
    }

    private List<OTPCredentialStorage> getCredentialStorages(IdentityContext context, TOTPCredentials credentials, CredentialStore<?> store) {
        List<OTPCredentialStorage> storages = store.retrieveCredentials(context, this.getAccount(context, credentials.getUsername()), OTPCredentialStorage.class);
        for (OTPCredentialStorage storage : new ArrayList<OTPCredentialStorage>(storages)) {
            if (CredentialUtils.isCurrentCredential(storage) && this.isDeviceStorage(credentials.getDevice(), storage)) continue;
            storages.remove(storage);
        }
        return storages;
    }

    private boolean isDeviceStorage(String device, OTPCredentialStorage storage) {
        return device == null || device.equals(storage.getDevice());
    }

    private String getDevice(String device) {
        if (StringUtil.isNullOrEmpty(device)) {
            device = DEFAULT_DEVICE;
        }
        return device;
    }

    private String getConfigurationProperty(CredentialStore<?> store, String key, String defaultValue) {
        Object value = store.getConfig().getCredentialHandlerProperties().get(key);
        if (value != null) {
            return String.valueOf(value);
        }
        return defaultValue;
    }
}

