/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.idm.file.internal.AbstractFileAttributedType;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileIdentityType;
import org.picketlink.idm.model.Partition;

public class FilePartition
extends AbstractFileAttributedType<Partition> {
    private static final long serialVersionUID = -8949732184464473476L;
    private static final String VERSION = "1";
    private transient String configurationName;
    private transient Map<String, Map<String, FileIdentityType>> identityTypes = new ConcurrentHashMap<String, Map<String, FileIdentityType>>();
    private transient Map<String, Map<String, List<FileCredentialStorage>>> credentials = new ConcurrentHashMap<String, Map<String, List<FileCredentialStorage>>>();

    protected FilePartition(Partition object, String configurationName) {
        super(VERSION, object);
        this.configurationName = configurationName;
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
        super.doReadObject(s);
        this.configurationName = s.readObject().toString();
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        super.doWriteObject(s);
        s.writeObject(this.configurationName);
    }

    @Override
    protected Partition doCreateInstance(Map<String, Serializable> properties) throws Exception {
        String name = properties.get("name").toString();
        return (Partition)Class.forName(this.getType()).getConstructor(String.class).newInstance(name);
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        super.doPopulateProperties(properties);
        Partition partition = (Partition)this.getEntry();
        properties.put("name", (Serializable)((Object)partition.getName()));
    }

    @Override
    protected Partition doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        Partition partition = (Partition)super.doPopulateEntry((Map)properties);
        return partition;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public Map<String, Map<String, FileIdentityType>> getIdentityTypes() {
        return this.identityTypes;
    }

    public void setIdentityTypes(Map<String, Map<String, FileIdentityType>> identityTypes) {
        this.identityTypes = identityTypes;
    }

    public Map<String, Map<String, List<FileCredentialStorage>>> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, Map<String, List<FileCredentialStorage>>> credentials) {
        this.credentials = credentials;
    }
}

