/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.internal.PrivilegeChainQuery;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultRelationshipQuery;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualRelationshipManager
extends AbstractIdentityContext
implements RelationshipManager {
    private StoreSelector storeSelector;
    private PrivilegeChainQuery privilegeChainQuery;

    public ContextualRelationshipManager(EventBridge eventBridge, IdGenerator idGenerator, StoreSelector storeSelector, PrivilegeChainQuery privilegeChainQuery) {
        super(null, eventBridge, idGenerator);
        this.storeSelector = storeSelector;
        this.privilegeChainQuery = privilegeChainQuery;
    }

    @Override
    public void add(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            this.storeSelector.getStoreForRelationshipOperation(this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.create).add(this, relationship);
            this.addAttributes(relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeAddFailed(relationship, e);
        }
    }

    @Override
    public void update(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            this.storeSelector.getStoreForRelationshipOperation(this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.update).update(this, relationship);
            this.removeAttributes(relationship);
            this.addAttributes(relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUpdateFailed(relationship, e);
        }
    }

    @Override
    public void remove(Relationship relationship) {
        if (relationship == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship");
        }
        try {
            List<?> result = this.createRelationshipQuery(relationship.getClass()).setParameter(Relationship.ID, relationship.getId()).getResultList();
            if (!result.isEmpty()) {
                this.removeAllAttributes(relationship);
            }
            this.storeSelector.getStoreForRelationshipOperation(this, relationship.getClass(), relationship, IdentityStoreConfiguration.IdentityOperation.delete).remove(this, relationship);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeRemoveFailed(relationship, e);
        }
    }

    @Override
    public <T extends Relationship> RelationshipQuery<T> createRelationshipQuery(Class<T> relationshipClass) {
        if (relationshipClass == null) {
            IDMInternalMessages.MESSAGES.nullArgument("Relationship Type");
        }
        return new DefaultRelationshipQuery<T>(this, relationshipClass, this.storeSelector);
    }

    private void removeAllAttributes(Relationship identityType) {
        Relationship storedType;
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null && (storedType = this.lookupById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                attributeStore.removeAttribute(this, identityType, attribute.getName());
            }
        }
    }

    private void addAttributes(Relationship identityType) {
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null) {
            for (Attribute<? extends Serializable> attribute : identityType.getAttributes()) {
                attributeStore.setAttribute(this, identityType, attribute);
            }
        }
    }

    private void removeAttributes(Relationship identityType) {
        Relationship storedType;
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null && (storedType = this.lookupById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                if (identityType.getAttribute(attribute.getName()) != null) continue;
                attributeStore.removeAttribute(this, identityType, attribute.getName());
            }
        }
    }

    private Relationship lookupById(Class<? extends Relationship> relationshipType, String id) {
        List<? extends Relationship> result = this.createRelationshipQuery(relationshipType).setParameter(Relationship.ID, id).getResultList();
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public boolean inheritsPrivileges(IdentityType identity, IdentityType assignee) {
        if (identity.equals(assignee)) {
            return true;
        }
        return this.privilegeChainQuery.inheritsPrivileges(this, identity, assignee);
    }
}

