/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

public class DefaultIdentityCache
implements IdentityCache {
    private Map<Partition, Map<String, Agent>> agentsCache = new HashMap<Partition, Map<String, Agent>>();
    private Map<Partition, Map<String, Role>> rolesCache = new HashMap<Partition, Map<String, Role>>();
    private Map<Partition, Map<String, Group>> groupsCache = new HashMap<Partition, Map<String, Group>>();

    @Override
    public User lookupUser(Realm realm, String loginName) {
        Agent agent = this.lookupAgent(realm, loginName);
        if (User.class.isInstance(agent)) {
            return (User)agent;
        }
        return null;
    }

    @Override
    public Group lookupGroup(Partition partition, String groupPath) {
        return this.getGroups(partition).get(groupPath);
    }

    @Override
    public Role lookupRole(Partition partition, String name) {
        return this.getRoles(partition).get(name);
    }

    @Override
    public void putUser(Realm realm, User user) {
        this.putAgent(realm, user);
    }

    @Override
    public void putGroup(Partition partition, Group group) {
        this.getGroups(partition).get(group.getPath());
    }

    @Override
    public void putRole(Partition partition, Role role) {
        this.getRoles(partition).put(role.getName(), role);
    }

    @Override
    public Agent lookupAgent(Realm realm, String loginName) {
        return this.getAgents(realm).get(loginName);
    }

    @Override
    public void putAgent(Realm realm, Agent agent) {
        this.getAgents(realm).get(agent.getLoginName());
    }

    @Override
    public void invalidate(Partition partition, IdentityType identityType) {
        if (Agent.class.isInstance(identityType)) {
            Agent agent = (Agent)identityType;
            this.getAgents((Realm)partition).remove(agent.getLoginName());
        } else if (Role.class.isInstance(identityType)) {
            Role role = (Role)identityType;
            this.getRoles(partition).remove(role.getName());
        } else if (Group.class.isInstance(identityType)) {
            Group group = (Group)identityType;
            this.getGroups(partition).remove(group.getPath());
        }
    }

    private Map<String, Agent> getAgents(Realm realm) {
        Map<String, Agent> agents = this.agentsCache.get(realm);
        if (agents == null) {
            agents = new HashMap<String, Agent>();
            this.agentsCache.put(realm, agents);
        }
        return agents;
    }

    private Map<String, Role> getRoles(Partition partition) {
        Map<String, Role> roles = this.rolesCache.get(partition);
        if (roles == null) {
            roles = new HashMap<String, Role>();
            this.rolesCache.put(partition, roles);
        }
        return roles;
    }

    private Map<String, Group> getGroups(Partition partition) {
        Map<String, Group> groups = this.groupsCache.get(partition);
        if (groups == null) {
            groups = new HashMap<String, Group>();
            this.groupsCache.put(partition, groups);
        }
        return groups;
    }
}

