/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.GroupStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.RoleStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.UserStorageUtil;
import org.picketlink.idm.model.Attribute;

public class AttributeStorageUtil
extends AbstractStorageUtil {
    public Attribute getAttribute(DataSource dataSource, String id, String attributeName) {
        Attribute<Object> attribute;
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Attribute<Object> attribute2 = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            List<? extends Serializable> valList;
            connection = dataSource.getConnection();
            String sql = "select attributeType from Attributes where owner =? and name=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, id);
            preparedStatement.setString(2, attributeName);
            resultSet = preparedStatement.executeQuery();
            String attributeType = null;
            if (resultSet.next()) {
                attributeType = resultSet.getString(1);
            }
            if ((valList = this.getAttributeValues(dataSource, id, attributeName)).size() > 1) {
                attribute2 = new Attribute<String>(attributeName, "dummy");
                if (this.isPrimitiveNativeType(attributeType)) {
                    this.handlePrimitiveAttributeType(attribute2, attributeType, valList);
                } else {
                    Serializable[] serialArray = new Serializable[valList.size()];
                    int i = 0;
                    for (Serializable serializable : valList) {
                        serialArray[i++] = serializable;
                    }
                    attribute2.setValue((String)serialArray);
                }
            } else {
                attribute2 = new Attribute<Serializable>(attributeName, valList.get(0));
            }
            attribute = attribute2;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return attribute;
    }

    public List<Attribute> getAttributes(DataSource dataSource, String ownerId) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select name,value from Attributes where owner =?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ownerId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String storedName = resultSet.getString(1);
                Attribute attribute = this.getAttribute(dataSource, ownerId, storedName);
                attributes.add(attribute);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return attributes;
    }

    public void setAttribute(DataSource dataSource, String ownerId, Attribute attribute) {
        Serializable serializedValues;
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Object values = attribute.getValue();
        if (!values.getClass().isArray()) {
            serializedValues = (Serializable)values;
            values = new Serializable[]{serializedValues};
        }
        if (values instanceof byte[]) {
            serializedValues = (Serializable)values;
            values = new Serializable[]{serializedValues};
        }
        for (Serializable attributeValue : (Serializable[])values) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "insert into Attributes set owner =?, name=?, value=?,attributeType=?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, ownerId);
                preparedStatement.setString(2, attribute.getName());
                preparedStatement.setString(3, Base64.encodeObject(attributeValue));
                preparedStatement.setString(4, attributeValue.getClass().getName());
                int result = preparedStatement.executeUpdate();
                if (result == 0) {
                    throw new RuntimeException("Update failed");
                }
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
    }

    public void deleteAttribute(DataSource dataSource, String ownerId, String attributeName) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "Delete from Attributes where owner =? and name=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ownerId);
            preparedStatement.setString(2, attributeName);
            int result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    private List<? extends Serializable> getAttributeValues(DataSource dataSource, String ownerId, String attributeName) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        ArrayList<String> stringList = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select value,attributeType from Attributes where owner =? and name=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, ownerId);
            preparedStatement.setString(2, attributeName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String attributeType = resultSet.getString(2);
                if (attributeType.equals(String.class.getName())) {
                    stringList.add((String)Base64.decodeToObject(resultSet.getString(1)));
                    continue;
                }
                list.add((Serializable)Base64.decodeToObject(resultSet.getString(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        if (!stringList.isEmpty()) {
            return stringList;
        }
        return list;
    }

    private boolean isPrimitiveNativeType(String attributeType) {
        return String.class.getName().equals(attributeType) || Integer.class.getName().equals(attributeType);
    }

    private void handlePrimitiveAttributeType(Attribute attribute, String attributeType, List<? extends Serializable> valueList) {
        if (String.class.getName().equals(attributeType)) {
            String[] serialArray = new String[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = serializable.toString();
            }
            attribute.setValue(serialArray);
        } else if (Integer.class.getName().equals(attributeType)) {
            Integer[] serialArray = new Integer[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = (Integer)serializable;
            }
            attribute.setValue(serialArray);
        } else if (Long.class.getName().equals(attributeType)) {
            Long[] serialArray = new Long[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = (Long)serializable;
            }
            attribute.setValue(serialArray);
        } else if (Double.class.getName().equals(attributeType)) {
            Double[] serialArray = new Double[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = (Double)serializable;
            }
            attribute.setValue(serialArray);
        } else if (Float.class.getName().equals(attributeType)) {
            Float[] serialArray = new Float[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = (Float)serializable;
            }
            attribute.setValue(serialArray);
        } else if (Short.class.getName().equals(attributeType)) {
            Short[] serialArray = new Short[valueList.size()];
            int i = 0;
            for (Serializable serializable : valueList) {
                serialArray[i++] = (Short)serializable;
            }
            attribute.setValue(serialArray);
        }
    }
}

