/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.GroupStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.RoleStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.UserStorageUtil;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

public class RelationshipStorageUtil
extends AbstractStorageUtil {
    public void deleteGrant(DataSource dataSource, String id) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        if (id == null) {
            throw IDMMessages.MESSAGES.nullArgument("id");
        }
        GregorianCalendar calendar = new GregorianCalendar(2400, 12, 12);
        Date expiration = calendar.getTime();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from Relationship where id=? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, id);
            preparedStatement.setString(2, Grant.class.getName());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete Grant failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void deleteGroupMembership(DataSource dataSource, String id) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        if (id == null) {
            throw IDMMessages.MESSAGES.nullArgument("id");
        }
        GregorianCalendar calendar = new GregorianCalendar(2400, 12, 12);
        Date expiration = calendar.getTime();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from Relationship where id=? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, id);
            preparedStatement.setString(2, GroupMembership.class.getName());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete Group Membership failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public Grant loadGrant(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block6: {
            Grant grant;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            if (id == null) {
                throw IDMMessages.MESSAGES.nullArgument("id");
            }
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "select relBegin,relEnd from Relationship where id =? and type=?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                preparedStatement.setString(2, Grant.class.getName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                Grant grant2 = new Grant();
                grant2.setId(id);
                grant2.setAssignee(userStorageUtil.loadUser(dataSource, resultSet.getString(1)));
                String roleId = resultSet.getString(2);
                grant2.setRole(roleStorageUtil.loadRole(dataSource, roleId));
                grant = grant2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return grant;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public GroupMembership loadGroupMembership(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block6: {
            GroupMembership groupMembership;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            if (id == null) {
                throw IDMMessages.MESSAGES.nullArgument("id");
            }
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "select relBegin,relEnd from Relationship where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                GroupMembership groupMembership2 = new GroupMembership();
                groupMembership2.setId(id);
                groupMembership2.setMember(userStorageUtil.loadUser(dataSource, resultSet.getString(1)));
                String groupID = resultSet.getString(2);
                groupMembership2.setGroup(groupStorageUtil.loadGroup(dataSource, groupID));
                groupMembership = groupMembership2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return groupMembership;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public List<Grant> loadGrantsForAgent(DataSource dataSource, Agent agent) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<Grant> grants = new ArrayList<Grant>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relEnd from Relationship where relBegin =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, agent.getId());
            preparedStatement.setString(2, Grant.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Grant grant = new Grant();
                grant.setId(resultSet.getString(1));
                grant.setAssignee(userStorageUtil.loadUser(dataSource, agent.getId()));
                String roleId = resultSet.getString(2);
                grant.setRole(roleStorageUtil.loadRole(dataSource, roleId));
                grants.add(grant);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return grants;
    }

    public List<Grant> loadGrantsForUser(DataSource dataSource, User user) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<Grant> grants = new ArrayList<Grant>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relEnd from Relationship where relBegin =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, user.getId());
            preparedStatement.setString(2, Grant.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Grant grant = new Grant();
                grant.setId(resultSet.getString(1));
                grant.setAssignee(userStorageUtil.loadUser(dataSource, user.getId()));
                String roleId = resultSet.getString(2);
                grant.setRole(roleStorageUtil.loadRole(dataSource, roleId));
                grants.add(grant);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return grants;
    }

    public List<GroupMembership> loadGroupMembershipsForAgent(DataSource dataSource, Agent agent) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<GroupMembership> groupMemberships = new ArrayList<GroupMembership>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relEnd from Relationship where relBegin =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, agent.getId());
            preparedStatement.setString(2, GroupMembership.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GroupMembership groupMembership = new GroupMembership();
                groupMembership.setId(resultSet.getString(1));
                groupMembership.setMember(userStorageUtil.loadUser(dataSource, agent.getId()));
                groupMembership.setGroup(groupStorageUtil.loadGroup(dataSource, resultSet.getString(2)));
                groupMemberships.add(groupMembership);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return groupMemberships;
    }

    public List<GroupMembership> loadGroupMembershipsForUser(DataSource dataSource, User user) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<GroupMembership> groupMemberships = new ArrayList<GroupMembership>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relEnd from Relationship where relBegin =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, user.getId());
            preparedStatement.setString(2, GroupMembership.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GroupMembership groupMembership = new GroupMembership();
                groupMembership.setId(resultSet.getString(1));
                groupMembership.setMember(userStorageUtil.loadUser(dataSource, user.getId()));
                groupMembership.setGroup(groupStorageUtil.loadGroup(dataSource, resultSet.getString(2)));
                groupMemberships.add(groupMembership);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return groupMemberships;
    }

    public List<Grant> loadGrantsForRole(DataSource dataSource, Role role) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<Grant> grants = new ArrayList<Grant>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relBegin from Relationship where relEnd =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, role.getId());
            preparedStatement.setString(2, Grant.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Grant grant = new Grant();
                grant.setId(resultSet.getString(1));
                grant.setAssignee(userStorageUtil.loadUser(dataSource, resultSet.getString(2)));
                grant.setRole(role);
                grants.add(grant);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return grants;
    }

    public List<GroupMembership> loadGroupMembershipForGroup(DataSource dataSource, Group group) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        ArrayList<GroupMembership> groupMemberships = new ArrayList<GroupMembership>();
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            String sql = "select id,relBegin from Relationship where relEnd =? and type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, group.getId());
            preparedStatement.setString(2, GroupMembership.class.getName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GroupMembership groupMembership = new GroupMembership();
                groupMembership.setId(resultSet.getString(1));
                groupMembership.setMember(userStorageUtil.loadUser(dataSource, resultSet.getString(2)));
                groupMembership.setGroup(group);
                groupMemberships.add(groupMembership);
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return groupMemberships;
    }

    public void storeGrant(DataSource dataSource, Grant grant) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        GregorianCalendar calendar = new GregorianCalendar(2400, 12, 12);
        Date expiration = calendar.getTime();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "insert into Relationship set id=?,relBegin=?,relEnd=?,type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, grant.getId());
            preparedStatement.setString(2, grant.getAssignee().getId());
            preparedStatement.setString(3, grant.getRole().getId());
            preparedStatement.setString(4, grant.getClass().getName());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Insert into Grant failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void storeGroupMembership(DataSource dataSource, GroupMembership groupMembership) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        GregorianCalendar calendar = new GregorianCalendar(2400, 12, 12);
        Date expiration = calendar.getTime();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "insert into Relationship set id=?,relBegin=?,relEnd=?,type=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, groupMembership.getId());
            preparedStatement.setString(2, groupMembership.getMember().getId());
            preparedStatement.setString(3, groupMembership.getGroup().getId());
            preparedStatement.setString(4, groupMembership.getClass().getName());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Insert into GroupMembership failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }
}

