/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.RelationshipMember;
import org.picketlink.idm.jpa.annotations.entity.IdentityManaged;
import org.picketlink.idm.jpa.annotations.entity.MappedAttribute;
import org.picketlink.idm.jpa.internal.AttributeList;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.mappers.AttributeTypeMapper;
import org.picketlink.idm.jpa.internal.mappers.AttributedValueMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.jpa.internal.mappers.IdentityTypeMapper;
import org.picketlink.idm.jpa.internal.mappers.ManagedCredentialAttributeMapper;
import org.picketlink.idm.jpa.internal.mappers.ModelMapper;
import org.picketlink.idm.jpa.internal.mappers.NamedMappedAttribute;
import org.picketlink.idm.jpa.internal.mappers.PartitionMapper;
import org.picketlink.idm.jpa.internal.mappers.PermissionMapper;
import org.picketlink.idm.jpa.internal.mappers.RelationshipIdentityMapper;
import org.picketlink.idm.jpa.internal.mappers.RelationshipMapper;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;

public class EntityMapper {
    private final List<EntityMapping> entityMappings;
    private final Class<?> entityType;
    private final JPAIdentityStore store;

    public EntityMapper(Class<?> entityType, JPAIdentityStore jpaIdentityStore) {
        this.entityType = entityType;
        this.store = jpaIdentityStore;
        ArrayList<EntityMapping> mappings = new ArrayList<EntityMapping>();
        for (ModelMapper modelMapper : this.getModelMappers()) {
            mappings.addAll(modelMapper.createMapping(entityType));
        }
        if (mappings.isEmpty()) {
            throw new IdentityManagementException("Entity [" + entityType + "] does not have any mapping.");
        }
        this.entityMappings = Collections.unmodifiableList(mappings);
    }

    public Object persist(AttributedType attributedType, EntityManager entityManager) {
        Object entity = this.getEntityInstance(attributedType, entityManager);
        if (entity != null) {
            EntityMapping entityMapping = this.getMappingsFor(attributedType.getClass());
            for (Property property : entityMapping.getProperties().keySet()) {
                AttributedType ownerType;
                Object propertyValue = property.getValue(attributedType);
                Property mappedProperty = entityMapping.getProperties().get(property);
                Object mappedValue = propertyValue;
                if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) {
                    ownerType = (AttributedType)propertyValue;
                    if ((ownerType == null || ownerType.getId() == null) && this.isPartitionSupported(ownerType.getClass())) {
                        throw new IdentityManagementException("Owner does not exist or was not provided.");
                    }
                    mappedValue = this.store.getOwnerEntity(ownerType, mappedProperty, entityManager);
                } else if (AttributedType.class.isInstance(propertyValue)) {
                    ownerType = (AttributedType)propertyValue;
                    if (this.store.isMappedType(mappedProperty.getJavaClass()) && ownerType != null) {
                        mappedValue = entityManager.find(mappedProperty.getJavaClass(), (Object)ownerType.getId());
                    }
                }
                mappedProperty.setValue(entity, mappedValue);
            }
            entityManager.persist(entity);
        }
        return entity;
    }

    public Object updateEntity(AttributedType attributedType, EntityManager entityManager) {
        Object entityInstance = this.getEntityInstance(attributedType, entityManager);
        if (entityInstance != null) {
            if (List.class.isInstance(entityInstance)) {
                List attributes = (List)entityInstance;
                if (AttributeList.class.isInstance(entityInstance)) {
                    for (Object attribute : ((AttributeList)attributes).getOriginalList()) {
                        if (attributes.contains(attribute)) continue;
                        entityManager.remove(attribute);
                    }
                }
                Iterator iterator = attributes.iterator();
                while (iterator.hasNext()) {
                    this.updateEntity(attributedType, iterator.next(), entityManager);
                }
            } else {
                this.updateEntity(attributedType, entityInstance, entityManager);
            }
        }
        return entityInstance;
    }

    public <P extends AttributedType> P createType(Object entityInstance, EntityManager entityManager) {
        AttributedType attributedType = null;
        if (entityInstance != null) {
            EntityMapper entityMapper;
            Map.Entry<Property, Property> property;
            if (!this.getEntityType().equals(entityInstance.getClass()) && !this.getEntityType().isAssignableFrom(entityInstance.getClass()) && (property = (entityMapper = this.store.getMapperForEntity(entityInstance.getClass())).getProperty(OwnerReference.class)) != null) {
                entityInstance = property.getValue().getValue(entityInstance);
            }
            try {
                attributedType = (AttributedType)Reflections.newInstance(entityInstance.getClass(), this.getTypeProperty().getValue(entityInstance).toString());
                EntityMapping entityMapping = this.getMappingsFor(attributedType.getClass());
                for (Property property2 : entityMapping.getProperties().keySet()) {
                    Object mappedValue;
                    Property mappedProperty = entityMapping.getProperties().get(property2);
                    Object propertyValue = mappedValue = mappedProperty.getValue(entityInstance);
                    if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) {
                        if (mappedValue == null) {
                            if (this.isPartitionSupported(property2.getJavaClass())) {
                                throw new IdentityManagementException("Owner does not exists or was not provided.");
                            }
                        } else {
                            EntityMapper entityMapper2 = this.store.getMapperForEntity(mappedValue.getClass());
                            propertyValue = entityMapper2.createType(mappedValue, entityManager);
                        }
                    } else if (this.store.isMappedType(mappedProperty.getJavaClass())) {
                        propertyValue = this.createType(mappedValue, entityManager);
                    }
                    property2.setValue(attributedType, propertyValue);
                }
                if (this.isRoot()) {
                    for (EntityMapper finalMapper : this.store.getMapperFor(attributedType.getClass())) {
                        if (finalMapper.isRoot()) continue;
                        for (Object child : this.getAssociatedEntities(attributedType, finalMapper, entityManager)) {
                            finalMapper.populate(attributedType, child, entityManager);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not create [" + attributedType + " from entity [" + entityInstance + "].", e);
            }
        }
        return (P)attributedType;
    }

    public Map.Entry<Property, Property> getProperty(Class<?> attributedType, String propertyName) {
        EntityMapping entityMapping = this.getMappingsFor(attributedType);
        for (Map.Entry<Property, Property> property : entityMapping.getProperties().entrySet()) {
            if (!property.getKey().getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public List<EntityMapping> getEntityMappings() {
        return this.entityMappings;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public Map.Entry<Property, Property> getProperty(Class<?> attributedType, Class<? extends Annotation> annotation) {
        EntityMapping entityMapping = this.getMappingsFor(attributedType);
        if (entityMapping != null) {
            for (Map.Entry<Property, Property> property : entityMapping.getProperties().entrySet()) {
                if (!property.getValue().getAnnotatedElement().isAnnotationPresent(annotation)) continue;
                return property;
            }
        }
        return null;
    }

    public Map.Entry<Property, Property> getProperty(Class<? extends Annotation> annotation) {
        for (EntityMapping entityMapping : this.getEntityMappings()) {
            for (Map.Entry<Property, Property> property : entityMapping.getProperties().entrySet()) {
                if (!property.getValue().getAnnotatedElement().isAnnotationPresent(annotation)) continue;
                return property;
            }
        }
        return null;
    }

    public EntityMapping getMappingsFor(Class<?> attributedType) {
        for (EntityMapping entityMapping : this.getEntityMappings()) {
            if (!entityMapping.getSupportedType().equals(attributedType)) continue;
            return entityMapping;
        }
        for (EntityMapping entityMapping : this.getEntityMappings()) {
            if (!entityMapping.getSupportedType().isAssignableFrom(attributedType)) continue;
            return entityMapping;
        }
        for (EntityMapping entityMapping : this.getEntityMappings()) {
            if (!attributedType.isAssignableFrom(entityMapping.getSupportedType())) continue;
            return entityMapping;
        }
        return null;
    }

    public boolean isRoot() {
        return this.getTypeProperty() != null;
    }

    public List getAssociatedEntities(AttributedType attributedType, EntityMapper entityMapper, EntityManager entityManager) {
        if (!entityMapper.getEntityType().isAnnotationPresent(IdentityManaged.class)) {
            return Collections.emptyList();
        }
        StringBuilder hql = new StringBuilder();
        hql.append("from ").append(entityMapper.getEntityType().getName()).append(" o where ");
        Map.Entry<Property, Property> ownerProperty = entityMapper.getProperty(attributedType.getClass(), OwnerReference.class);
        if (ownerProperty == null) {
            return Collections.emptyList();
        }
        hql.append(" o.").append(ownerProperty.getValue().getName()).append(" = :owner");
        Query childQuery = entityManager.createQuery(hql.toString());
        Object ownerEntity = this.store.getOwnerEntity(attributedType, ownerProperty.getValue(), entityManager);
        childQuery.setParameter("owner", ownerEntity);
        return childQuery.getResultList();
    }

    public Object createEntity() {
        try {
            return Reflections.newInstance(this.getEntityType(), this.getEntityType().getName());
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.instantiationError(this.getEntityType(), e);
        }
    }

    private <V extends AttributedType> void populate(V attributedType, Object entityInstance, EntityManager entityManager) {
        if (this.getEntityType().isAnnotationPresent(MappedAttribute.class)) {
            MappedAttribute mappedAttribute = this.getEntityType().getAnnotation(MappedAttribute.class);
            Property<Object> property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new NamedPropertyCriteria(mappedAttribute.value())).getFirstResult();
            if (property != null) {
                if (List.class.isAssignableFrom(property.getJavaClass())) {
                    List instances = (List)property.getValue(attributedType);
                    if (instances == null) {
                        instances = new AttributeList();
                    }
                    instances.add(entityInstance);
                    entityInstance = instances;
                }
                property.setValue(attributedType, entityInstance);
            }
        } else {
            for (EntityMapping entityMapping : this.getEntityMappings()) {
                for (Property property : entityMapping.getProperties().keySet()) {
                    Property mappedProperty = entityMapping.getProperties().get(property);
                    if (mappedProperty.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) continue;
                    Object mappedPropertyValue = mappedProperty.getValue(entityInstance);
                    if (mappedPropertyValue != null && this.store.isMappedType(mappedProperty.getJavaClass())) {
                        EntityMapper entityMapper = this.store.getMapperForEntity(mappedProperty.getJavaClass());
                        Map.Entry<Property, Property> ownerProperty = entityMapper.getProperty(OwnerReference.class);
                        if (ownerProperty != null) {
                            entityMapper = this.store.getMapperForEntity(ownerProperty.getValue().getJavaClass());
                        }
                        mappedPropertyValue = entityMapper.createType(mappedPropertyValue, entityManager);
                    }
                    property.setValue(attributedType, mappedPropertyValue);
                }
            }
        }
    }

    private void updateEntity(AttributedType attributedType, Object entityInstance, EntityManager entityManager) {
        EntityMapping entityMapping = this.getMappingsFor(attributedType.getClass());
        for (Property property : entityMapping.getProperties().keySet()) {
            Property mappedProperty = entityMapping.getProperties().get(property);
            Object value = property.getValue(attributedType);
            if (value != null && this.store.isMappedType(mappedProperty.getJavaClass())) {
                EntityMapper entityMapper = this.store.getMapperForEntity(mappedProperty.getJavaClass());
                if (mappedProperty.getJavaClass().equals(entityMapper.getEntityType())) {
                    AttributedType referencedType = (AttributedType)value;
                    value = this.store.getOwnerEntity(referencedType, mappedProperty, entityManager);
                }
            }
            mappedProperty.setValue(entityInstance, value);
        }
        entityManager.persist(entityInstance);
    }

    public Property getTypeProperty() {
        for (EntityMapping entityMapping : this.getEntityMappings()) {
            if (entityMapping.getTypeProperty() == null) continue;
            return entityMapping.getTypeProperty();
        }
        return null;
    }

    private List<ModelMapper> getModelMappers() {
        ArrayList<ModelMapper> modelMappers = new ArrayList<ModelMapper>();
        modelMappers.add(new PartitionMapper());
        modelMappers.add(new IdentityTypeMapper());
        modelMappers.add(new RelationshipMapper());
        modelMappers.add(new RelationshipIdentityMapper());
        modelMappers.add(new AttributedValueMapper());
        modelMappers.add(new NamedMappedAttribute());
        modelMappers.add(new AttributeTypeMapper());
        modelMappers.add(new ManagedCredentialAttributeMapper());
        modelMappers.add(new PermissionMapper());
        return modelMappers;
    }

    private Object getEntityInstance(AttributedType attributedType, EntityManager entityManager) {
        if (this.getProperty(RelationshipMember.class) != null) {
            return null;
        }
        Object entityInstance = null;
        if (this.getEntityType().isAnnotationPresent(MappedAttribute.class)) {
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new NamedPropertyCriteria(this.getEntityType().getAnnotation(MappedAttribute.class).value())).getFirstResult();
            if (property != null && (entityInstance = property.getValue(attributedType)) == null) {
                for (Object child : this.getAssociatedEntities(attributedType, this, entityManager)) {
                    entityManager.remove(child);
                }
            }
        } else {
            if (this.isRoot()) {
                entityInstance = entityManager.find(this.getEntityType(), (Object)attributedType.getId());
            } else {
                List associatedEntities;
                Property attributeProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(this.getEntityType(), TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
                if (attributeProperty != null) {
                    entityInstance = attributeProperty.getValue(attributedType);
                } else if (!Relationship.class.isInstance(attributedType) && !(associatedEntities = this.getAssociatedEntities(attributedType, this, entityManager)).isEmpty()) {
                    if (associatedEntities.size() > 1) {
                        throw new IdentityManagementException("Unexpected associated references count.");
                    }
                    entityInstance = associatedEntities.get(0);
                }
            }
            if (entityInstance == null) {
                entityInstance = this.createEntity();
            }
        }
        return entityInstance;
    }

    private boolean isPartitionSupported(Class<?> type) {
        return Partition.class.isAssignableFrom(type) && ((JPAIdentityStoreConfiguration)this.store.getConfig()).supportsPartition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMapper that = (EntityMapper)o;
        return this.entityType.equals(that.entityType);
    }

    public int hashCode() {
        return this.entityType.hashCode();
    }
}

