/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPUtil;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
extends AbstractIdentityStore<LDAPIdentityStoreConfiguration>
implements CredentialStore<LDAPIdentityStoreConfiguration> {
    public static final String EMPTY_ATTRIBUTE_VALUE = " ";
    private LDAPOperationManager operationManager;

    @Override
    public void setup(LDAPIdentityStoreConfiguration config) {
        super.setup(config);
        if (config.isActiveDirectory()) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapActiveDirectoryConfiguration();
        }
        try {
            this.operationManager = new LDAPOperationManager((LDAPIdentityStoreConfiguration)this.getConfig());
        }
        catch (NamingException e) {
            throw IDMInternalMessages.MESSAGES.storeLdapCouldNotCreateContext(e);
        }
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.addRelationship((Relationship)attributedType);
        } else {
            this.operationManager.createSubContext(this.getBindingDN(attributedType), this.extractAttributes(attributedType, true));
            this.addToParentAsMember(attributedType);
            attributedType.setId(this.getEntryIdentifier(attributedType));
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapRelationshipUpdateNotSupported(attributedType);
        } else {
            BasicAttributes updatedAttributes = this.extractAttributes(attributedType, false);
            NamingEnumeration<Attribute> attributes = updatedAttributes.getAll();
            try {
                while (attributes.hasMore()) {
                    this.operationManager.modifyAttribute(this.getBindingDN(attributedType), attributes.next());
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not update attributes.", ne);
            }
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.removeRelationship((Relationship)attributedType);
        } else {
            this.operationManager.removeEntryById(this.getBaseDN(attributedType), attributedType.getId());
        }
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
        String bindingDN = this.getBindingDN(identityType);
        for (LDAPMappingConfiguration relationshipConfig : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
            for (String attributeName : relationshipConfig.getMappedProperties().values()) {
                StringBuilder filter = new StringBuilder();
                filter.append("(&(").append(attributeName).append("=").append("").append(bindingDN).append("))");
                try {
                    List<SearchResult> search = this.operationManager.search(this.getMappingConfig(relationshipConfig.getRelatedAttributedType()).getBaseDN(), filter.toString(), this.getMappingConfig(relationshipConfig.getRelatedAttributedType()));
                    for (SearchResult result : search) {
                        Attributes attributes = result.getAttributes();
                        Attribute relationshipAttribute = attributes.get(attributeName);
                        if (relationshipAttribute == null || !relationshipAttribute.contains(bindingDN)) continue;
                        relationshipAttribute.remove(bindingDN);
                        if (relationshipAttribute.size() == 0) {
                            relationshipAttribute.add(EMPTY_ATTRIBUTE_VALUE);
                        }
                        this.operationManager.modifyAttribute(result.getNameInNamespace(), relationshipAttribute);
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException("Could not remove " + identityType + " from relationship " + relationshipConfig.getMappedClass(), e);
                }
            }
        }
    }

    @Override
    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList<IdentityType> results = new ArrayList<IdentityType>();
        try {
            LDAPMappingConfiguration ldapEntryConfig;
            StringBuilder filter;
            if (identityQuery.getParameter(IdentityType.PARTITION) != null) {
                return results;
            }
            if (identityQuery.getParameter(IdentityType.ID) != null) {
                Object[] queryParameterValues = identityQuery.getParameter(IdentityType.ID);
                SearchResult search = this.operationManager.lookupById(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), queryParameterValues[0].toString(), null);
                if (search != null) {
                    results.add((IdentityType)this.populateAttributedType(search, null));
                }
                return results;
            }
            if (!IdentityType.class.equals(identityQuery.getIdentityType()) && (filter = this.createIdentityTypeSearchFilter(identityQuery, ldapEntryConfig = this.getMappingConfig(identityQuery.getIdentityType()))).length() != 0) {
                List<SearchResult> search = this.operationManager.search(this.getBaseDN(ldapEntryConfig), filter.toString(), ldapEntryConfig);
                for (SearchResult result : search) {
                    results.add((IdentityType)this.populateAttributedType(result, null));
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryIdentityTypeFailed(identityQuery, e);
        }
        return results;
    }

    @Override
    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        ArrayList<V> results = new ArrayList<V>();
        if (Relationship.class.equals(query.getRelationshipClass())) {
            for (LDAPMappingConfiguration configuration : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
                results.addAll(this.fetchRelationships(query, configuration));
            }
        } else {
            results.addAll(this.fetchRelationships(query, this.getMappingConfig(query.getRelationshipClass())));
        }
        return results;
    }

    private String getRelationshipMappedProperty(Class<? extends IdentityType> identityType, LDAPMappingConfiguration mappingConfig) {
        Property property = PropertyQueries.createQuery(mappingConfig.getMappedClass()).addCriteria(new TypedPropertyCriteria(identityType, TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
        if (property == null) {
            return null;
        }
        return mappingConfig.getMappedProperties().get(property.getName());
    }

    private <V extends Relationship> List<V> fetchRelationships(RelationshipQuery<V> query, LDAPMappingConfiguration mappingConfig) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        Class<? extends AttributedType> relationshipClass = mappingConfig.getMappedClass();
        Map<QueryParameter, Object[]> parameters = query.getParameters();
        LDAPMappingConfiguration relatedTypeConfig = this.getMappingConfig(mappingConfig.getRelatedAttributedType());
        StringBuilder filter = new StringBuilder();
        filter.append("(&").append((CharSequence)this.getObjectClassesFilter(relatedTypeConfig));
        ArrayList<String> entriesToFilter = new ArrayList<String>();
        for (QueryParameter queryParameter : parameters.keySet()) {
            Object[] values = parameters.get(queryParameter);
            RelationshipQueryParameter relationshipQueryParameter = null;
            String attributeName = null;
            if (RelationshipQueryParameter.class.isInstance(queryParameter)) {
                relationshipQueryParameter = (RelationshipQueryParameter)queryParameter;
                attributeName = mappingConfig.getMappedProperties().get(relationshipQueryParameter.getName());
            } else {
                if (!Relationship.IDENTITY.equals(queryParameter)) continue;
                IdentityType identityType = (IdentityType)values[0];
                if (!mappingConfig.getRelatedAttributedType().isInstance(identityType)) {
                    attributeName = this.getRelationshipMappedProperty(identityType.getClass(), mappingConfig);
                }
            }
            for (Object value : values) {
                Property property;
                AttributedType attributedType = (AttributedType)value;
                if (!((LDAPIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.read)) {
                    return results;
                }
                String bindingDN = null;
                SearchResult result = this.operationManager.lookupById(this.getBaseDN(attributedType), attributedType.getId(), this.getMappingConfig(attributedType.getClass()));
                if (result != null) {
                    bindingDN = result.getNameInNamespace();
                    if (!attributedType.getClass().equals(relatedTypeConfig.getMappedClass())) {
                        entriesToFilter.add(bindingDN);
                    }
                }
                boolean filterByOwner = attributedType.getClass().equals(relatedTypeConfig.getMappedClass());
                if (attributeName != null && (property = PropertyQueries.createQuery(relationshipClass).addCriteria(new NamedPropertyCriteria(attributeName)).getFirstResult()) != null) {
                    filterByOwner = property.getJavaClass().equals(relatedTypeConfig.getMappedClass());
                }
                if (filterByOwner) {
                    filter.append(this.operationManager.getFilterById(this.getBaseDN(attributedType), attributedType.getId()));
                    continue;
                }
                filter.append("(").append(attributeName).append("=").append(bindingDN).append(")");
            }
        }
        filter.append(")");
        try {
            if (filter.length() > 0) {
                String baseDN = this.getBaseDN(relatedTypeConfig);
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Search relationships for type [%s] using filter [%] and baseDN [%s]", relationshipClass, filter.toString(), baseDN);
                }
                List<SearchResult> search = this.operationManager.search(baseDN, filter.toString(), relatedTypeConfig);
                for (SearchResult entry : search) {
                    if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found entry [%s] for relationship ", entry.getNameInNamespace(), relationshipClass);
                    }
                    Attributes ownerAttributes = entry.getAttributes();
                    AttributedType ownerType = this.populateAttributedType(entry, null);
                    for (Map.Entry<String, String> memberAttribute : mappingConfig.getMappedProperties().entrySet()) {
                        String attributeName = memberAttribute.getValue();
                        Attribute attribute = ownerAttributes.get(attributeName);
                        NamingEnumeration<?> attributeValues = attribute.getAll();
                        while (attributeValues.hasMore()) {
                            String dn;
                            String attributeValue = attributeValues.next().toString();
                            if (!entriesToFilter.isEmpty() && !entriesToFilter.contains(attributeValue)) continue;
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Processing relationship [%s] from attribute [%s] with attributeValue [%s]", relationshipClass, attributeName, attributeValue);
                            }
                            if (StringUtil.isNullOrEmpty(attributeValue.trim())) continue;
                            Property<AttributedType> associatedProperty = PropertyQueries.createQuery(relationshipClass).addCriteria(new NamedPropertyCriteria(memberAttribute.getKey())).getSingleResult();
                            String memberBaseDN = attributeValue.substring(attributeValue.indexOf(",") + 1);
                            List<SearchResult> result = this.operationManager.search(memberBaseDN, dn = attributeValue.substring(0, attributeValue.indexOf(",")), null);
                            if (result.isEmpty()) {
                                throw new IdentityManagementException("Associated entry does not exists [" + attributeValue + "].");
                            }
                            Property<AttributedType> property = PropertyQueries.createQuery(relationshipClass).addCriteria(new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
                            if (!property.getJavaClass().isAssignableFrom(ownerType.getClass())) continue;
                            Relationship relationship = (Relationship)Reflections.newInstance(relationshipClass);
                            property.setValue(relationship, ownerType);
                            SearchResult member = result.get(0);
                            AttributedType relType = this.populateAttributedType(member, null);
                            if (!associatedProperty.getJavaClass().isAssignableFrom(relType.getClass())) continue;
                            associatedProperty.setValue(relationship, relType);
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Relationship [%s] created from attribute [%s] with attributeValue [%s]", relationshipClass, attributeName, attributeValue);
                            }
                            results.add(relationship);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryRelationshipFailed(query, e);
        }
        return results;
    }

    @Override
    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
    }

    @Override
    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    @Override
    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
    }

    private String getBaseDN(LDAPMappingConfiguration ldapEntryConfig) {
        String baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        if (ldapEntryConfig.getBaseDN() != null) {
            baseDN = ldapEntryConfig.getBaseDN();
        }
        return baseDN;
    }

    private <V extends IdentityType> StringBuilder createIdentityTypeSearchFilter(IdentityQuery<V> identityQuery, LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder filter = new StringBuilder();
        for (Map.Entry<QueryParameter, Object[]> entry : identityQuery.getParameters().entrySet()) {
            Object[] queryParameterValues;
            QueryParameter queryParameter = entry.getKey();
            if (IdentityType.ID.equals(queryParameter) || (queryParameterValues = entry.getValue()).length <= 0 || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            String attributeName = ldapEntryConfig.getMappedProperties().get(attributeParameter.getName());
            if (attributeName == null) continue;
            Object attributeValue = queryParameterValues[0];
            if (Date.class.isInstance(attributeValue)) {
                attributeValue = LDAPUtil.formatDate((Date)attributeValue);
            }
            if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                filter.append("(").append(attributeName).append(">=").append(attributeValue).append(")");
                continue;
            }
            if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                filter.append("(").append(attributeName).append("<=").append(attributeValue).append(")");
                continue;
            }
            filter.append("(").append(attributeName).append("=").append(attributeValue).append(")");
        }
        if (filter.length() != 0) {
            filter.insert(0, "(&(");
            if (ldapEntryConfig != null) {
                filter.append((CharSequence)this.getObjectClassesFilter(ldapEntryConfig));
            } else {
                filter.append("(").append("objectclass").append("=").append("*").append(")");
            }
            filter.append("))");
        }
        return filter;
    }

    private StringBuilder getObjectClassesFilter(LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder builder = new StringBuilder();
        for (String objectClass : ldapEntryConfig.getObjectClasses()) {
            builder.append("(objectClass=").append(objectClass).append(")");
        }
        return builder;
    }

    private void addRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes entryAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String relationshipTypeProperty : mappingConfig.getMappedProperties().keySet()) {
            Property relationshipProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new NamedPropertyCriteria(relationshipTypeProperty)).getSingleResult();
            Attribute attribute = entryAttributes.get(mappingConfig.getMappedProperties().get(relationshipTypeProperty));
            if (attribute == null) continue;
            ArrayList<String> membersToRemove = new ArrayList<String>();
            String memberDN = this.getBindingDN((AttributedType)relationshipProperty.getValue(relationship));
            try {
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object value = attributeValues.next();
                    if (value.toString().trim().equals(EMPTY_ATTRIBUTE_VALUE.trim())) {
                        membersToRemove.add(EMPTY_ATTRIBUTE_VALUE);
                        membersToRemove.add(EMPTY_ATTRIBUTE_VALUE.trim());
                    }
                    if (!value.toString().toLowerCase().equals(memberDN.toLowerCase())) continue;
                    membersToRemove.add(value.toString());
                }
                for (String memberToRemove : membersToRemove) {
                    attribute.remove(memberToRemove);
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not iterate over members for relationship [" + relationship + "].", ne);
            }
            attribute.add(memberDN);
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType), attribute);
        }
    }

    private AttributedType getRelationshipOwner(Relationship relationship) {
        Class<? extends AttributedType> ownertType = this.getMappingConfig(relationship.getClass()).getRelatedAttributedType();
        Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new TypedPropertyCriteria(ownertType)).getSingleResult();
        return (AttributedType)property.getValue(relationship);
    }

    private void removeRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes ownerAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String typeProperty : mappingConfig.getMappedProperties().keySet()) {
            String childDN;
            Property relProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new NamedPropertyCriteria(typeProperty)).getSingleResult();
            Attribute mappedAttribute = ownerAttributes.get(mappingConfig.getMappedProperties().get(typeProperty));
            if (mappedAttribute != null && mappedAttribute.contains(childDN = this.getBindingDN((AttributedType)relProperty.getValue(relationship)))) {
                mappedAttribute.remove(childDN);
            }
            if (mappedAttribute != null && mappedAttribute.size() == 0) {
                mappedAttribute.add(EMPTY_ATTRIBUTE_VALUE);
            }
            if (mappedAttribute == null) continue;
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType), mappedAttribute);
        }
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType) {
        return this.populateAttributedType(searchResult, attributedType, 0);
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType, int hierarchyDepthCount) {
        try {
            LDAPMappingConfiguration mappingConfig;
            String entryDN = searchResult.getNameInNamespace();
            String entryBaseDN = entryDN.substring(entryDN.indexOf(",") + 1);
            Attributes attributes = searchResult.getAttributes();
            if (attributedType == null) {
                attributedType = Reflections.newInstance(((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(entryBaseDN, this.getEntryObjectClasses(attributes)));
            }
            if (hierarchyDepthCount > (mappingConfig = this.getMappingConfig(attributedType.getClass())).getHierarchySearchDepth()) {
                return null;
            }
            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating attributed type [%s] from DN [%s]", attributedType, entryDN);
            }
            NamingEnumeration<? extends Attribute> ldapAttributes = attributes.getAll();
            while (ldapAttributes.hasMore()) {
                Object attributeValue;
                Attribute ldapAttribute = ldapAttributes.next();
                try {
                    attributeValue = ldapAttribute.get();
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                String attributeName = ldapAttribute.getID();
                if (attributeName.toLowerCase().equals(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName().toLowerCase())) {
                    attributedType.setId(this.operationManager.decodeEntryUUID(attributeValue));
                    continue;
                }
                List properties = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
                for (Property<Object> property : properties) {
                    String ldapAttributeName = mappingConfig.getMappedProperties().get(property.getName());
                    if (ldapAttributeName == null || !ldapAttributeName.toLowerCase().equals(attributeName.toLowerCase())) continue;
                    if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating property [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{property.getName(), attributeName, attributeValue, entryBaseDN});
                    }
                    if (property.getJavaClass().equals(Date.class)) {
                        property.setValue(attributedType, LDAPUtil.parseDate(attributeValue.toString()));
                        continue;
                    }
                    property.setValue(attributedType, attributeValue);
                }
            }
            if (IdentityType.class.isInstance(attributedType)) {
                IdentityType identityType = (IdentityType)attributedType;
                String createdTimestamp = attributes.get("createTimeStamp").get().toString();
                identityType.setCreatedDate(LDAPUtil.parseDate(createdTimestamp));
            }
            LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
            if (mappingConfig.getParentMembershipAttributeName() != null) {
                List<SearchResult> search;
                StringBuilder filter = new StringBuilder("(&");
                filter.append("(").append((CharSequence)this.getObjectClassesFilter(entryConfig)).append(")").append("(").append(mappingConfig.getParentMembershipAttributeName()).append("=").append("").append(this.getBindingName(attributedType)).append(",").append(entryBaseDN).append(")");
                filter.append(")");
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Searching parent entry for DN [%s] using filter [%s].", entryDN, filter.toString());
                }
                if (!(search = this.operationManager.search(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), filter.toString(), entryConfig)).isEmpty()) {
                    SearchResult next = search.get(0);
                    Property<AttributedType> parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
                    if (parentProperty != null) {
                        String string = next.getNameInNamespace();
                        String parentBaseDN = string.substring(string.indexOf(",") + 1);
                        Class<? extends AttributedType> baseDNType = ((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(parentBaseDN, this.getEntryObjectClasses(attributes));
                        if (parentProperty.getJavaClass().isAssignableFrom(baseDNType)) {
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found parent [%s] for entry for DN [%s].", string, entryDN);
                            }
                            int hierarchyDepthCount1 = ++hierarchyDepthCount;
                            parentProperty.setValue(attributedType, this.populateAttributedType(next, null, hierarchyDepthCount1));
                        }
                    }
                } else if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("No parent entry found for DN [%s] using filter [%s].", entryDN, filter.toString());
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not populate attribute type " + attributedType + ".", e);
        }
        return attributedType;
    }

    private List<String> getEntryObjectClasses(Attributes attributes) throws NamingException {
        Attribute objectClassesAttribute = attributes.get("objectclass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        if (objectClassesAttribute == null) {
            return objectClasses;
        }
        NamingEnumeration<?> all = objectClassesAttribute.getAll();
        while (all.hasMore()) {
            objectClasses.add(all.next().toString());
        }
        return objectClasses;
    }

    private String getBindingName(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property<String> idProperty = mappingConfig.getIdProperty();
        return mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + idProperty.getValue(attributedType);
    }

    private BasicAttributes extractAttributes(AttributedType attributedType, boolean extractObjectClasses) {
        BasicAttributes entryAttributes = new BasicAttributes();
        Map<String, String> mappedProperties = this.getMappingConfig(attributedType.getClass()).getMappedProperties();
        for (String propertyName : mappedProperties.keySet()) {
            if (this.getMappingConfig(attributedType.getClass()).getReadOnlyAttributes().contains(propertyName)) continue;
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new NamedPropertyCriteria(propertyName)).getSingleResult();
            Object propertyValue = property.getValue(attributedType);
            if (AttributedType.class.isInstance(propertyValue)) {
                AttributedType referencedType = (AttributedType)propertyValue;
                propertyValue = this.getBindingDN(referencedType);
            } else if (propertyValue == null || StringUtil.isNullOrEmpty(propertyValue.toString())) {
                propertyValue = EMPTY_ATTRIBUTE_VALUE;
            }
            entryAttributes.put(mappedProperties.get(propertyName), propertyValue);
        }
        if (extractObjectClasses) {
            LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(attributedType.getClass());
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            for (String objectClassValue : ldapEntryConfig.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
                if (!objectClassValue.equals("groupOfNames") && !objectClassValue.equals("groupOfEntries") && !objectClassValue.equals("groupOfUniqueNames")) continue;
                entryAttributes.put("member", EMPTY_ATTRIBUTE_VALUE);
            }
            entryAttributes.put(objectClassAttribute);
        }
        return entryAttributes;
    }

    private LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfiguration mappingConfig = ((LDAPIdentityStoreConfiguration)this.getConfig()).getMappingConfig(attributedType);
        if (mappingConfig == null) {
            throw new IdentityManagementException("Not mapped type [" + attributedType + "].");
        }
        return mappingConfig;
    }

    LDAPOperationManager getOperationManager() {
        return this.operationManager;
    }

    String getBindingDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property<String> idProperty = mappingConfig.getIdProperty();
        String baseDN = mappingConfig.getBaseDN() == null ? "" : "," + this.getBaseDN(attributedType);
        return mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + idProperty.getValue(attributedType) + baseDN;
    }

    private String getBaseDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        String baseDN = mappingConfig.getBaseDN();
        String parentDN = mappingConfig.getParentMapping().get(mappingConfig.getIdProperty().getValue(attributedType));
        if (parentDN != null) {
            baseDN = parentDN;
        } else {
            AttributedType parentType;
            Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
            if (parentProperty != null && (parentType = (AttributedType)parentProperty.getValue(attributedType)) != null) {
                Property<String> parentIdProperty = this.getMappingConfig(parentType.getClass()).getIdProperty();
                String parentId = parentIdProperty.getValue(parentType);
                String parentBaseDN = mappingConfig.getParentMapping().get(parentId);
                baseDN = parentBaseDN != null ? parentBaseDN : this.getBaseDN(parentType);
            }
        }
        if (baseDN == null) {
            baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        }
        return baseDN;
    }

    private void addToParentAsMember(AttributedType attributedType) {
        AttributedType parentType;
        Property parentProperty;
        LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
        if (entryConfig.getParentMembershipAttributeName() != null && (parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult()) != null && (parentType = (AttributedType)parentProperty.getValue(attributedType)) != null) {
            Attributes attributes = this.operationManager.getAttributes(parentType.getId(), this.getBaseDN(parentType), entryConfig);
            Attribute attribute = attributes.get(entryConfig.getParentMembershipAttributeName());
            attribute.add(this.getBindingDN(attributedType));
            this.operationManager.modifyAttribute(this.getBindingDN(parentType), attribute);
        }
    }

    private String getEntryIdentifier(AttributedType attributedType) {
        try {
            List<SearchResult> search = this.operationManager.search(this.getBaseDN(attributedType), "(" + this.getBindingName(attributedType) + ")", this.getMappingConfig(attributedType.getClass()));
            Attribute id = search.get(0).getAttributes().get(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName());
            if (id == null) {
                throw new IdentityManagementException("Could not retrieve identifier for entry [" + this.getBindingDN(attributedType) + "].");
            }
            return this.operationManager.decodeEntryUUID(id.get());
        }
        catch (NamingException ne) {
            throw new IdentityManagementException("Could not add type [" + attributedType + "].", ne);
        }
    }
}

