/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Date;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={UsernamePasswordCredentials.class, Password.class}, credentialStorage=SupportsCredentials.NO_CREDENTIAL_STORAGE.class)
public class LDAPPlainTextPasswordCredentialHandler<S, V, U>
implements CredentialHandler<LDAPIdentityStore, UsernamePasswordCredentials, Password> {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    @Override
    public void setup(LDAPIdentityStore store) {
    }

    @Override
    public void validate(IdentityContext context, UsernamePasswordCredentials credentials, LDAPIdentityStore store) {
        Account account;
        credentials.setStatus(Credentials.Status.INVALID);
        credentials.setValidatedAccount(null);
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Validating credentials [%s][%s] using identity store [%s] and credential handler [%s].", new Object[]{credentials.getClass(), credentials, store, this});
        }
        if ((account = this.getAccount(context, credentials.getUsername())) != null) {
            if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
                IDMLog.CREDENTIAL_LOGGER.debugf("Found account [%s] from credentials [%s].", account, credentials);
            }
            if (account.isEnabled()) {
                if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is ENABLED.", account, credentials);
                }
                LDAPIdentityStore ldapIdentityStore = store;
                char[] password = credentials.getPassword().getValue();
                String bindingDN = ldapIdentityStore.getBindingDN(account);
                LDAPOperationManager operationManager = ldapIdentityStore.getOperationManager();
                if (operationManager.authenticate(bindingDN, new String(password))) {
                    credentials.setValidatedAccount(account);
                    credentials.setStatus(Credentials.Status.VALID);
                }
            } else {
                if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
                    IDMLog.CREDENTIAL_LOGGER.debugf("Account [%s] is DISABLED.", account, credentials);
                }
                credentials.setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        } else if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Account NOT FOUND for credentials [%s][%s].", credentials.getClass(), credentials);
        }
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Credential [%s][%s] validated using identity store [%s] and credential handler [%s]. Status [%s]. Validated Account [%s]", new Object[]{credentials.getClass(), credentials, store, this, credentials.getStatus(), credentials.getValidatedAccount()});
        }
    }

    @Override
    public void update(IdentityContext context, Account account, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        if (((LDAPIdentityStoreConfiguration)store.getConfig()).isActiveDirectory()) {
            this.updateADPassword(account, new String(password.getValue()), store);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                store.getOperationManager().modifyAttribute(store.getBindingDN(account), mod0);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating password.", e);
            }
        }
    }

    private void updateADPassword(Account account, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getOperationManager().modifyAttribute(store.getBindingDN(account), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Account getAccount(IdentityContext context, String loginName) {
        Agent agent;
        IdentityManager identityManager = this.getIdentityManager(context);
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Trying to find account [%s] using default account type [%s]. If you're using a custom account type, it will not be retrieved until you provide a credential handler that knows how to retrieve it.", loginName, Agent.class);
        }
        if ((agent = BasicModel.getAgent(identityManager, loginName)) == null) {
            agent = BasicModel.getUser(identityManager, loginName);
        }
        return agent;
    }

    protected IdentityManager getIdentityManager(IdentityContext context) {
        IdentityManager identityManager = (IdentityManager)context.getParameter("IDENTITY_MANAGER_CTX_PARAMETER");
        if (identityManager == null) {
            throw new IdentityManagementException("IdentityManager not set into context.");
        }
        return identityManager;
    }
}

