/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.util.IDMUtil;

public class DefaultIdentityQuery<T extends IdentityType>
implements IdentityQuery<T> {
    private final Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private final IdentityContext context;
    private final Class<T> identityType;
    private final StoreSelector storeSelector;
    private int offset;
    private int limit;
    private QueryParameter[] sortParameters;
    private boolean sortAscending = true;

    public DefaultIdentityQuery(IdentityContext context, Class<T> identityType, StoreSelector storeSelector) {
        this.context = context;
        this.storeSelector = storeSelector;
        this.identityType = identityType;
    }

    @Override
    public IdentityQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    @Override
    public Class<T> getIdentityType() {
        return this.identityType;
    }

    @Override
    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    @Override
    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    @Override
    public Map<QueryParameter, Object[]> getParameters(Class<?> type) {
        HashMap<QueryParameter, Object[]> typedParameters = new HashMap<QueryParameter, Object[]>();
        Set<Map.Entry<QueryParameter, Object[]>> entrySet = this.parameters.entrySet();
        for (Map.Entry<QueryParameter, Object[]> entry : entrySet) {
            if (!type.isInstance(entry.getKey())) continue;
            typedParameters.put(entry.getKey(), entry.getValue());
        }
        return typedParameters;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public QueryParameter[] getSortParameters() {
        return this.sortParameters;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public List<T> getResultList() {
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        try {
            Set<IdentityStore<?>> identityStores = this.storeSelector.getStoresForIdentityQuery(this.context, this.getIdentityType());
            Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this.context);
            for (IdentityStore<?> store : identityStores) {
                for (IdentityType identityType : store.fetchQueryResults(this.context, this)) {
                    IDMUtil.configureDefaultPartition(identityType, store, this.getPartitionManager());
                    if (attributeStore != null) {
                        attributeStore.loadAttributes(this.context, identityType);
                    }
                    result.add(identityType);
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryIdentityTypeFailed(this, e);
        }
        return result;
    }

    @Override
    public int getResultCount() {
        int count = 0;
        Set<IdentityStore<?>> identityStores = this.storeSelector.getStoresForIdentityQuery(this.context, this.getIdentityType());
        for (IdentityStore<?> store : identityStores) {
            count += store.countQueryResults(this.context, this);
        }
        return count;
    }

    @Override
    public IdentityQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public IdentityQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public IdentityQuery<T> setSortParameters(QueryParameter ... sortParameters) {
        this.sortParameters = sortParameters;
        return this;
    }

    @Override
    public IdentityQuery<T> setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
        return this;
    }

    private PartitionManager getPartitionManager() {
        return (PartitionManager)((Object)this.storeSelector);
    }
}

