/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.spi.IdentityStore;

public class IDMUtil {
    public static <P> Set<P> toSet(P[] values) {
        return new HashSet<P>(Arrays.asList(values));
    }

    public static <P extends Class<?>> int isTypeSupported(P type, Set<P> supportedTypes, Set<P> unsupportedTypes) {
        int score = -1;
        for (Class cls : supportedTypes) {
            int clsScore = IDMUtil.calcScore(type, cls);
            if (clsScore <= score || !supportedTypes.contains(cls)) continue;
            score = clsScore;
        }
        for (Class cls : unsupportedTypes) {
            if (!cls.isAssignableFrom(type) || !unsupportedTypes.contains(cls)) continue;
            score = -1;
            break;
        }
        return score;
    }

    public static int isTypeOperationSupported(Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes) {
        int score = -1;
        for (Class<? extends AttributedType> cls : supportedTypes.keySet()) {
            int clsScore = IDMUtil.calcScore(type, cls);
            if (clsScore <= score || !supportedTypes.get(cls).contains((Object)operation)) continue;
            score = clsScore;
        }
        for (Class<? extends AttributedType> cls : unsupportedTypes.keySet()) {
            if (!cls.isAssignableFrom(type) || !unsupportedTypes.get(cls).contains((Object)operation)) continue;
            score = -1;
            break;
        }
        return score;
    }

    private static int calcScore(Class<?> type, Class<?> targetClass) {
        if (type.equals(targetClass)) {
            return 0;
        }
        if (targetClass.isAssignableFrom(type)) {
            int score = 0;
            for (Class<?> cls = type.getSuperclass(); cls != null && !cls.equals(Object.class) && targetClass.isAssignableFrom(cls); cls = cls.getSuperclass()) {
                ++score;
            }
            return score;
        }
        return -1;
    }

    public static void configureDefaultPartition(IdentityType identityType, IdentityStore identityStore, PartitionManager partitionManager) {
        if (identityType != null) {
            Property parentProperty;
            if (identityType.getPartition() == null) {
                Realm defaultPartition = partitionManager.getPartition(Realm.class, "default");
                IDMLog.ROOT_LOGGER.partitionUndefinedForTypeUsingDefault(identityType, identityStore, defaultPartition);
                identityType.setPartition(defaultPartition);
            }
            if ((parentProperty = PropertyQueries.createQuery(identityType.getClass()).addCriteria(new TypedPropertyCriteria(identityType.getClass(), TypedPropertyCriteria.MatchOption.SUB_TYPE)).getFirstResult()) != null) {
                IDMUtil.configureDefaultPartition((IdentityType)parentProperty.getValue(identityType), identityStore, partitionManager);
            }
        }
    }
}

