/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.exception.control.event.ExceptionToCatchEvent;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.security.api.authorization.AccessDeniedException;
import org.apache.deltaspike.security.impl.authorization.SkipInternalProcessingException;
import org.apache.deltaspike.security.impl.extension.Authorizer;
import org.apache.deltaspike.security.impl.extension.SecurityExtension;
import org.apache.deltaspike.security.impl.extension.SecurityMetaDataStorage;
import org.apache.deltaspike.security.spi.authorization.SecurityStrategy;

@Dependent
public class DefaultSecurityStrategy
implements SecurityStrategy {
    private static final long serialVersionUID = 7992336651801599079L;
    @Inject
    private BeanManager beanManager;
    @Inject
    private SecurityExtension securityExtension;

    @Override
    public Object execute(InvocationContext invocationContext) throws Exception {
        Method method = invocationContext.getMethod();
        SecurityMetaDataStorage metaDataStorage = this.securityExtension.getMetaDataStorage();
        Class targetClass = ProxyUtils.getUnproxiedClass(invocationContext.getTarget().getClass());
        Set<Authorizer> authorizers = metaDataStorage.getAuthorizers(targetClass, method);
        this.invokeBeforeMethodInvocationAuthorizers(invocationContext, authorizers);
        Object result = invocationContext.proceed();
        this.invokeAfterMethodInvocationAuthorizers(invocationContext, authorizers, result);
        return result;
    }

    protected void invokeBeforeMethodInvocationAuthorizers(InvocationContext invocationContext, Set<Authorizer> authorizers) throws IllegalAccessException {
        block4: {
            try {
                for (Authorizer authorizer : authorizers) {
                    if (!authorizer.isBeforeMethodInvocationAuthorizer()) continue;
                    authorizer.authorize(invocationContext, null, this.beanManager);
                }
            }
            catch (SkipInternalProcessingException e) {
                throw e.getAccessDeniedException();
            }
            catch (AccessDeniedException e) {
                RuntimeException exceptionToThrow = this.handleAccessDeniedException(e);
                if (exceptionToThrow == null) break block4;
                throw exceptionToThrow;
            }
        }
    }

    protected void invokeAfterMethodInvocationAuthorizers(InvocationContext invocationContext, Set<Authorizer> authorizers, Object result) throws IllegalAccessException {
        block3: {
            try {
                for (Authorizer authorizer : authorizers) {
                    if (!authorizer.isAfterMethodInvocationAuthorizer()) continue;
                    authorizer.authorize(invocationContext, result, this.beanManager);
                }
            }
            catch (AccessDeniedException e) {
                RuntimeException exceptionToThrow = this.handleAccessDeniedException(e);
                if (exceptionToThrow == null) break block3;
                throw exceptionToThrow;
            }
        }
    }

    protected RuntimeException handleAccessDeniedException(AccessDeniedException originalException) {
        ExceptionToCatchEvent exceptionToCatchEvent = new ExceptionToCatchEvent(originalException);
        this.beanManager.fireEvent((Object)exceptionToCatchEvent, new Annotation[0]);
        if (!exceptionToCatchEvent.isHandled()) {
            throw originalException;
        }
        return null;
    }
}

