/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authorization.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.picketlink.Identity;
import org.picketlink.authentication.levels.Level;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.IdentityStereotype;
import org.picketlink.idm.model.annotation.RelationshipStereotype;
import org.picketlink.idm.model.annotation.StereotypeProperty;
import org.picketlink.idm.query.IdentityQueryBuilder;

public class AuthorizationUtil {
    public static boolean isLoggedIn(Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("You must provide an Identity instance.");
        }
        return identity.isLoggedIn();
    }

    public static boolean hasPermission(Identity identity, Object resource, Class<?> resourceClass, Serializable resourceIdentifier, String operation) {
        if (resource == null && resourceClass == null) {
            throw new IllegalArgumentException("You must provide a resource or resourceClass in order to check a permission.");
        }
        if (StringUtil.isNullOrEmpty(operation)) {
            throw new IllegalArgumentException("You must provide an operation in order to check a permission.");
        }
        if (!AuthorizationUtil.isLoggedIn(identity)) {
            return false;
        }
        if (resource != null && !StringUtil.isNullOrEmpty(resource.toString())) {
            return identity.hasPermission(resource, operation);
        }
        if (resourceClass != null) {
            if (resourceIdentifier == null || StringUtil.isNullOrEmpty(resourceIdentifier.toString())) {
                resourceIdentifier = null;
            }
            return identity.hasPermission(resourceClass, resourceIdentifier, operation);
        }
        return false;
    }

    public static boolean hasRole(Identity identity, PartitionManager partitionManager, String roleName) {
        if (!AuthorizationUtil.isLoggedIn(identity)) {
            return false;
        }
        ArrayList<Class<? extends AttributedType>> roleTypes = new ArrayList<Class<? extends AttributedType>>();
        ArrayList<Class<? extends AttributedType>> grantRelationshipTypes = new ArrayList<Class<? extends AttributedType>>();
        for (IdentityConfiguration configuration : partitionManager.getConfigurations()) {
            for (IdentityStoreConfiguration identityStoreConfiguration : configuration.getStoreConfiguration()) {
                for (Class<? extends AttributedType> clazz : identityStoreConfiguration.getSupportedTypes().keySet()) {
                    RelationshipStereotype relationshipStereotype;
                    IdentityStereotype identityStereotype;
                    if (IdentityType.class.isAssignableFrom(clazz) && (identityStereotype = clazz.getAnnotation(IdentityStereotype.class)) != null && IdentityStereotype.Stereotype.ROLE.equals((Object)identityStereotype.value())) {
                        roleTypes.add(clazz);
                    }
                    if (!Relationship.class.isAssignableFrom(clazz) || (relationshipStereotype = clazz.getAnnotation(RelationshipStereotype.class)) == null || !RelationshipStereotype.Stereotype.GRANT.equals((Object)relationshipStereotype.value())) continue;
                    grantRelationshipTypes.add(clazz);
                }
            }
        }
        ArrayList roles = new ArrayList();
        for (Class clazz : roleTypes) {
            List list = PropertyQueries.createQuery(clazz).addCriteria(new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
            for (Property property : list) {
                StereotypeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
                StereotypeProperty.Property stereotypeProperty = attributeProperty.value();
                if (!StereotypeProperty.Property.IDENTITY_ROLE_NAME.equals((Object)stereotypeProperty)) continue;
                for (Partition partition : partitionManager.getPartitions(Partition.class)) {
                    IdentityManager identityManager = partitionManager.createIdentityManager(partition);
                    IdentityQueryBuilder queryBuilder = identityManager.getQueryBuilder();
                    List result = queryBuilder.createIdentityQuery(clazz).where(queryBuilder.equal(AttributedType.QUERY_ATTRIBUTE.byName(property.getName()), roleName)).getResultList();
                    if (result.isEmpty()) continue;
                    roles.add(result.get(0));
                }
            }
        }
        RelationshipManager relationshipManager = partitionManager.createRelationshipManager();
        for (IdentityType identityType : roles) {
            for (Class clazz : grantRelationshipTypes) {
                List result;
                List relationshipStereotypeProperties = PropertyQueries.createQuery(clazz).addCriteria(new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
                Property roleProperty = null;
                Property accountProperty = null;
                for (Property property : relationshipStereotypeProperties) {
                    StereotypeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
                    StereotypeProperty.Property stereotypeProperty = attributeProperty.value();
                    if (StereotypeProperty.Property.RELATIONSHIP_GRANT_ROLE.equals((Object)stereotypeProperty)) {
                        roleProperty = property;
                        continue;
                    }
                    if (!StereotypeProperty.Property.RELATIONSHIP_GRANT_ASSIGNEE.equals((Object)stereotypeProperty)) continue;
                    accountProperty = property;
                }
                if (roleProperty == null || accountProperty == null || (result = relationshipManager.createRelationshipQuery(clazz).setParameter(Relationship.RELATIONSHIP_QUERY_ATTRIBUTE.byName(roleProperty.getName()), identityType).setParameter(Relationship.RELATIONSHIP_QUERY_ATTRIBUTE.byName(accountProperty.getName()), identity.getAccount()).getResultList()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMember(Identity identity, PartitionManager partitionManager, String groupName) {
        if (!AuthorizationUtil.isLoggedIn(identity)) {
            return false;
        }
        ArrayList<Class<? extends AttributedType>> groupTypes = new ArrayList<Class<? extends AttributedType>>();
        ArrayList<Class<? extends AttributedType>> groupMembershipTypes = new ArrayList<Class<? extends AttributedType>>();
        for (IdentityConfiguration configuration : partitionManager.getConfigurations()) {
            for (IdentityStoreConfiguration identityStoreConfiguration : configuration.getStoreConfiguration()) {
                for (Class<? extends AttributedType> clazz : identityStoreConfiguration.getSupportedTypes().keySet()) {
                    RelationshipStereotype relationshipStereotype;
                    IdentityStereotype identityStereotype;
                    if (IdentityType.class.isAssignableFrom(clazz) && (identityStereotype = clazz.getAnnotation(IdentityStereotype.class)) != null && IdentityStereotype.Stereotype.GROUP.equals((Object)identityStereotype.value())) {
                        groupTypes.add(clazz);
                    }
                    if (!Relationship.class.isAssignableFrom(clazz) || (relationshipStereotype = clazz.getAnnotation(RelationshipStereotype.class)) == null || !RelationshipStereotype.Stereotype.GROUP_MEMBERSHIP.equals((Object)relationshipStereotype.value())) continue;
                    groupMembershipTypes.add(clazz);
                }
            }
        }
        ArrayList groups = new ArrayList();
        for (Class clazz : groupTypes) {
            List list = PropertyQueries.createQuery(clazz).addCriteria(new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
            for (Property property : list) {
                StereotypeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
                StereotypeProperty.Property stereotypeProperty = attributeProperty.value();
                if (!StereotypeProperty.Property.IDENTITY_GROUP_NAME.equals((Object)stereotypeProperty)) continue;
                for (Partition partition : partitionManager.getPartitions(Partition.class)) {
                    IdentityManager identityManager = partitionManager.createIdentityManager(partition);
                    IdentityQueryBuilder queryBuilder = identityManager.getQueryBuilder();
                    List result = queryBuilder.createIdentityQuery(clazz).where(queryBuilder.equal(AttributedType.QUERY_ATTRIBUTE.byName(property.getName()), groupName)).getResultList();
                    if (result.isEmpty()) continue;
                    groups.add(result.get(0));
                }
            }
        }
        RelationshipManager relationshipManager = partitionManager.createRelationshipManager();
        for (IdentityType identityType : groups) {
            for (Class clazz : groupMembershipTypes) {
                List result;
                List relationshipStereotypeProperties = PropertyQueries.createQuery(clazz).addCriteria(new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
                Property groupProperty = null;
                Property memberProperty = null;
                for (Property property : relationshipStereotypeProperties) {
                    StereotypeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
                    StereotypeProperty.Property stereotypeProperty = attributeProperty.value();
                    if (StereotypeProperty.Property.RELATIONSHIP_GROUP_MEMBERSHIP_GROUP.equals((Object)stereotypeProperty)) {
                        groupProperty = property;
                        continue;
                    }
                    if (!StereotypeProperty.Property.RELATIONSHIP_GROUP_MEMBERSHIP_MEMBER.equals((Object)stereotypeProperty)) continue;
                    memberProperty = property;
                }
                if (groupProperty == null || memberProperty == null || (result = relationshipManager.createRelationshipQuery(clazz).setParameter(Relationship.RELATIONSHIP_QUERY_ATTRIBUTE.byName(groupProperty.getName()), identityType).setParameter(Relationship.RELATIONSHIP_QUERY_ATTRIBUTE.byName(memberProperty.getName()), identity.getAccount()).getResultList()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPartition(Identity identity, Class<?> partitionType, String ... partitionNames) {
        if (!AuthorizationUtil.isLoggedIn(identity)) {
            return false;
        }
        Account account = identity.getAccount();
        Partition partition = account.getPartition();
        if (partitionType != null && !partitionType.isInstance(partition)) {
            return false;
        }
        if (partitionNames == null) {
            return true;
        }
        if (partitionNames.length == 1 && StringUtil.isNullOrEmpty(partitionNames[0])) {
            return true;
        }
        for (String partitionName : partitionNames) {
            if (StringUtil.isNullOrEmpty(partitionName) || !partition.getName().equals(partitionName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLevel(Identity identity, Level level) {
        return level.compareTo(identity.getLevel()) <= 0;
    }
}

