/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes;

import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.config.http.DigestAuthenticationConfiguration;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.http.authentication.HttpAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.support.HTTPDigestUtil;
import org.picketlink.http.internal.authentication.schemes.support.NonceCache;
import org.picketlink.http.internal.util.RequestUtil;
import org.picketlink.idm.credential.Digest;

public class DigestAuthenticationScheme
implements HttpAuthenticationScheme<DigestAuthenticationConfiguration> {
    public static final String REALM_NAME_INIT_PARAM = "realmName";
    public static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    private final Timer nonceCleanupTimer = new Timer("PicketLink_Digest_Nonce_Cache_Cleanup");
    private final NonceCache nonceCache = new NonceCache();
    private String realm = "PicketLink Default Realm";

    @Override
    public void initialize(DigestAuthenticationConfiguration config) {
        String providedRealm = config.getRealmName();
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
        this.nonceCleanupTimer.schedule((TimerTask)this.nonceCache, this.nonceCache.getNonceMaxValid(), this.nonceCache.getNonceMaxValid());
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        String[] tokens;
        if (this.isDigestAuthentication(request) && (tokens = this.extractTokens(request)).length > 0) {
            Digest credential = HTTPDigestUtil.digest(tokens);
            credential.setMethod(request.getMethod());
            if (this.nonceCache.hasValidNonce(credential, request)) {
                creds.setCredential(credential);
            }
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) {
        try {
            String domain = request.getContextPath();
            if (domain == null) {
                domain = "/";
            }
            String newNonce = this.nonceCache.generateAndCacheNonce(request);
            StringBuilder str = new StringBuilder("Digest realm=\"");
            str.append(this.realm).append("\",");
            str.append("domain=\"").append(domain).append("\",");
            str.append("nonce=\"").append(newNonce).append("\",");
            str.append("algorithm=MD5,");
            str.append("qop=").append("auth").append(",");
            str.append("stale=\"").append(false).append("\"");
            response.setHeader("WWW-Authenticate", str.toString());
            if (RequestUtil.isAjaxRequest(request)) {
                response.sendError(403);
            } else {
                response.sendError(401);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not challenge client credentials.", e);
        }
    }

    @Override
    public void onPostAuthentication(HttpServletRequest request, HttpServletResponse response) {
    }

    private String[] extractTokens(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request).substring(7).trim();
        return authorizationHeader.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
    }

    private String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    private boolean isDigestAuthentication(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        return authorizationHeader != null && authorizationHeader.startsWith("Digest ");
    }
}

