/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authorization;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authorization.util.AuthorizationUtil;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.http.internal.authorization.AbstractPathAuthorizer;
import org.picketlink.idm.model.Partition;

public class RealmPathAuthorizer
extends AbstractPathAuthorizer {
    @Override
    public boolean doAuthorize(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationConfiguration authorizationConfiguration = pathConfiguration.getAuthorizationConfiguration();
        String[] allowedRealms = authorizationConfiguration.getAllowedRealms();
        if (allowedRealms == null) {
            return true;
        }
        Identity identity = this.getIdentity();
        for (String realmName : allowedRealms) {
            if (AuthorizationUtil.hasPartition(identity, Partition.class, realmName)) {
                return true;
            }
            try {
                Class partitionType = Reflections.classForName(realmName, new ClassLoader[0]);
                if (!AuthorizationUtil.hasPartition(identity, partitionType, null)) continue;
                return true;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return false;
    }
}

