/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.cors;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.config.http.CORSConfiguration;
import org.picketlink.http.internal.cors.CorsUtil;
import org.picketlink.log.BaseLog;

public class CORS {
    public static final String ORIGIN = "Origin";
    public static final String HOST = "Host";
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, POST, HEAD, OPTIONS";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD = "*";

    public static void handleActualRequest(CORSConfiguration corsConfiguration, HttpServletRequest request, HttpServletResponse response) {
        BaseLog.HTTP_LOGGER.debugf("Processing CORS Actual Request to path [%s].", request.getRequestURI());
        String requestOrigin = request.getHeader(ORIGIN);
        if (requestOrigin == null) {
            BaseLog.HTTP_LOGGER.debug("CORS origin header is null");
            throw new RuntimeException("CORS origin header is null");
        }
        Set<String> allowedOrigins = corsConfiguration.getAllowedOrigins();
        if (allowedOrigins == null || !allowedOrigins.contains(requestOrigin) && !allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD) && !corsConfiguration.isAllowAnyOrigin()) {
            BaseLog.HTTP_LOGGER.debug("CORS origin denied " + requestOrigin);
            throw new RuntimeException("CORS origin denied " + requestOrigin);
        }
        if (!corsConfiguration.isAllowAnyMethod()) {
            String method = request.getMethod().toUpperCase();
            Set<String> allowedMethods = corsConfiguration.getAllowedMethods();
            if (!allowedMethods.contains(method)) {
                BaseLog.HTTP_LOGGER.debug("Unsupported HTTP method " + method);
                throw new RuntimeException("Unsupported HTTP method " + method);
            }
        }
        if (corsConfiguration.isAllowCredentials()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
        } else if (corsConfiguration.isAllowAnyOrigin()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        } else {
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
        }
        Set<String> exposedHeaders = corsConfiguration.getExposedHeaders();
        if (exposedHeaders != null && !exposedHeaders.isEmpty()) {
            response.addHeader(ACCESS_CONTROL_EXPOSE_HEADERS, CorsUtil.join(exposedHeaders));
        }
    }

    public static void handlePreflightRequest(CORSConfiguration corsConfiguration, HttpServletRequest request, HttpServletResponse response) {
        Set<String> allowedOrigins;
        BaseLog.HTTP_LOGGER.debugf("Processing CORS Preflight Request to path [%s].", request.getRequestURI());
        String requestOrigin = request.getHeader(ORIGIN);
        if (requestOrigin == null) {
            BaseLog.HTTP_LOGGER.debug("CORS origin header is null");
            throw new RuntimeException("CORS origin header is null");
        }
        boolean allowAnyOrigin = corsConfiguration.isAllowAnyOrigin();
        if (!(allowAnyOrigin || (allowedOrigins = corsConfiguration.getAllowedOrigins()) != null && (allowedOrigins.contains(requestOrigin) || allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD) || allowAnyOrigin))) {
            BaseLog.HTTP_LOGGER.debug("CORS origin denied " + requestOrigin);
            throw new RuntimeException("CORS origin denied " + requestOrigin);
        }
        Set<String> allowedMethods = corsConfiguration.getAllowedMethods();
        if (!corsConfiguration.isAllowAnyMethod()) {
            String requestMethodHeader = request.getHeader(ACCESS_CONTROL_REQUEST_METHOD);
            String requestedMethod = requestMethodHeader.toUpperCase();
            if (!allowedMethods.contains(requestedMethod)) {
                BaseLog.HTTP_LOGGER.debug("Unsupported HTTP access control request method " + requestedMethod);
                throw new RuntimeException("Unsupported HTTP access control request method " + requestedMethod);
            }
            if (requestMethodHeader == null) {
                BaseLog.HTTP_LOGGER.debug("Invalid preflight CORS request: Missing Access-Control-Request-Method header");
                throw new RuntimeException("Invalid preflight CORS request: Missing Access-Control-Request-Method header");
            }
        }
        String rawRequestHeadersString = request.getHeader(ACCESS_CONTROL_REQUEST_HEADERS);
        String[] requestHeaderValues = CorsUtil.parseMultipleHeaderValues(rawRequestHeadersString);
        String[] requestHeaders = new String[requestHeaderValues.length];
        for (int i = 0; i < requestHeaders.length; ++i) {
            try {
                requestHeaders[i] = CorsUtil.formatCanonical(requestHeaderValues[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                BaseLog.HTTP_LOGGER.debug("Invalid preflight CORS request: Bad request header value " + requestHeaderValues[i]);
                throw new RuntimeException("Invalid preflight CORS request: Bad request header value " + requestHeaderValues[i]);
            }
        }
        Set<String> allowedHeaders = corsConfiguration.getAllowedHeaders();
        if (!corsConfiguration.isAllowAnyHeader()) {
            for (String requestHeader : requestHeaders) {
                if (allowedHeaders.contains(requestHeader)) continue;
                BaseLog.HTTP_LOGGER.debug("Unsupported HTTP access control request header " + requestHeader);
                throw new RuntimeException("Unsupported HTTP access control request header " + requestHeader);
            }
        }
        if (corsConfiguration.isAllowCredentials()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
        } else if (allowAnyOrigin) {
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        } else {
            response.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
        }
        long maxAge = corsConfiguration.getMaxAge();
        if (Long.valueOf(maxAge) != null && maxAge > 0L) {
            response.addHeader(ACCESS_CONTROL_MAX_AGE, String.valueOf(maxAge));
        } else {
            response.addHeader(ACCESS_CONTROL_MAX_AGE, String.valueOf(DEFAULT_MAX_AGE));
        }
        if (allowedMethods != null && !allowedMethods.isEmpty()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, CorsUtil.join(allowedMethods));
        } else {
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, DEFAULT_ALLOW_METHODS);
        }
        if (corsConfiguration.isAllowAnyHeader() && rawRequestHeadersString != null) {
            response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, rawRequestHeadersString);
        } else if (allowedHeaders != null && !allowedHeaders.isEmpty()) {
            response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, CorsUtil.join(allowedHeaders));
        }
    }
}

