/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.encoder;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.encoder.PasswordEncoder;

public class SHAPasswordEncoder
implements PasswordEncoder {
    private int strength;

    public SHAPasswordEncoder(int strength) {
        this.strength = strength;
    }

    @Override
    public String encode(String rawPassword) {
        MessageDigest messageDigest = this.getMessageDigest();
        String encodedPassword = null;
        try {
            byte[] digest = messageDigest.digest(rawPassword.getBytes("UTF-8"));
            encodedPassword = Base64.encodeBytes(digest);
        }
        catch (UnsupportedEncodingException e) {
            throw IDMMessages.MESSAGES.credentialCouldNotEncodePassword(e);
        }
        return encodedPassword;
    }

    @Override
    public boolean verify(String rawPassword, String encodedPassword) {
        return this.encode(rawPassword).equals(encodedPassword);
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        String algorithm = "SHA-" + this.strength;
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw IDMMessages.MESSAGES.credentialInvalidEncodingAlgorithm(algorithm, this, e);
        }
    }

    public int getStrength() {
        return this.strength;
    }
}

