/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.picketlink.idm.file.internal.AbstractFileType;
import org.picketlink.idm.model.AbstractIdentityType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.permission.IdentityPermission;
import org.picketlink.idm.permission.Permission;

public class FilePermission
extends AbstractFileType<Permission> {
    private static final String VERSION = "1";
    private String identityTypeId;

    protected FilePermission(IdentityType identityType, Permission permission) {
        super(VERSION, permission);
        this.identityTypeId = identityType.getId();
    }

    @Override
    protected Permission doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        Class resourceClass = (Class)properties.get("resourceClass");
        String operation = (String)((Object)properties.get("operation"));
        Serializable resourceIdentifier = properties.get("resourceIdentifier");
        return new IdentityPermission(resourceClass, resourceIdentifier, new AbstractIdentityType(){

            @Override
            public String getId() {
                return FilePermission.this.identityTypeId;
            }
        }, operation);
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        Permission entry = (Permission)this.getEntry();
        properties.put("resourceClass", entry.getResourceClass());
        properties.put("operation", (Serializable)((Object)entry.getOperation()));
        properties.put("resourceIdentifier", entry.getResourceIdentifier());
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        super.doWriteObject(s);
        s.writeObject(this.identityTypeId);
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
        super.doReadObject(s);
        this.identityTypeId = s.readObject().toString();
    }

    public String getIdentityTypeId() {
        return this.identityTypeId;
    }
}

