/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;

public abstract class AbstractAttributeStore<C extends IdentityStoreConfiguration>
extends AbstractIdentityStore<C>
implements AttributeStore<C> {
    @Override
    public <V extends Serializable> Attribute<V> getAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        this.loadAttributes(context, attributedType);
        return attributedType.getAttribute(attributeName);
    }

    @Override
    public void loadAttributes(IdentityContext identityContext, AttributedType attributedType) {
        Collection<Attribute<Serializable>> attributes = this.getAttributes(identityContext, attributedType);
        for (Attribute<Serializable> attribute : attributes) {
            attributedType.setAttribute(attribute);
            if (!this.isTraceEnabled()) continue;
            IDMLog.IDENTITY_STORE_LOGGER.tracef("Ad-hoc attribute [%s] loaded into type [%s] with identifier [%s] and value [%s]", new Object[]{attribute.getName(), attributedType.getClass(), attributedType.getId(), attribute.getValue()});
        }
        this.loadManagedAttributes(attributedType);
    }

    @Override
    public void setAttribute(IdentityContext context, AttributedType attributedType, Attribute<? extends Serializable> attribute) {
        this.doSetAttribute(context, attributedType, attribute);
        attributedType.setAttribute(attribute);
        if (this.isTraceEnabled()) {
            IDMLog.IDENTITY_STORE_LOGGER.tracef("Ad-hoc attribute [%s] stored for type [%s] with identifier [%s] and value [%s]", new Object[]{attribute.getName(), attributedType.getClass(), attributedType.getId(), attribute.getValue()});
        }
    }

    protected abstract void doSetAttribute(IdentityContext var1, AttributedType var2, Attribute<? extends Serializable> var3);

    protected abstract Collection<Attribute<? extends Serializable>> getAttributes(IdentityContext var1, AttributedType var2);

    private void loadManagedAttributes(AttributedType attributedType) {
        for (Attribute<? extends Serializable> attribute : attributedType.getAttributes()) {
            List properties = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
            for (Property<Serializable> property : properties) {
                AttributeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(AttributeProperty.class);
                if (!property.getName().equals(attribute.getName()) || !attributeProperty.managed()) continue;
                Serializable value = null;
                if (attribute != null) {
                    value = attribute.getValue();
                }
                property.setValue(attributedType, value);
                if (!this.isTraceEnabled()) continue;
                IDMLog.IDENTITY_STORE_LOGGER.tracef("Managed attribute [%s] loaded into type [%s] with identifier [%s] and value [%s]", new Object[]{attribute.getName(), attributedType.getClass(), attributedType.getId(), attribute.getValue()});
            }
        }
    }

    private boolean isTraceEnabled() {
        return IDMLog.IDENTITY_STORE_LOGGER.isTraceEnabled();
    }
}

