/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.AttributedTypeManager;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultIdentityContext;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.internal.PartitionManagerConfiguration;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public abstract class AbstractAttributedTypeManager<T extends AttributedType>
implements AttributedTypeManager<T> {
    private final IdentityContext identityContext;
    private final PartitionManagerConfiguration configuration;

    AbstractAttributedTypeManager(PartitionManagerConfiguration configuration, Partition partition) {
        this.configuration = configuration;
        this.identityContext = this.createIdentityContext(partition, configuration.getEventBridge(), configuration.getIdGenerator());
    }

    public AbstractAttributedTypeManager(PartitionManagerConfiguration configuration) {
        this(configuration, null);
    }

    public AbstractAttributedTypeManager(DefaultPartitionManager partitionManager) {
        this(partitionManager.getConfiguration(), null);
    }

    @Override
    public void add(T attributedType) throws IdentityManagementException {
        if (attributedType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("AttributedType");
        }
        this.checkUniqueness(attributedType);
        try {
            this.doAdd(attributedType);
            this.addAttributes(this.identityContext, (AttributedType)attributedType);
            this.fireAttributedTypeAddedEvent(attributedType);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeAddFailed((AttributedType)attributedType, e);
        }
    }

    protected abstract void fireAttributedTypeAddedEvent(T var1);

    protected abstract void doAdd(T var1);

    @Override
    public void update(T attributedType) throws IdentityManagementException {
        if (attributedType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("AttributedType");
        }
        this.checkIfExists(attributedType);
        try {
            this.doUpdate(attributedType);
            Object storedType = this.lookupById(attributedType.getClass(), attributedType.getId());
            this.removeAttributes(this.identityContext, (AttributedType)attributedType, (AttributedType)storedType);
            this.addAttributes(this.identityContext, (AttributedType)attributedType);
            this.fireAttributedTypeUpdatedEvent(attributedType);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUpdateFailed((AttributedType)attributedType, e);
        }
    }

    protected abstract void fireAttributedTypeUpdatedEvent(T var1);

    protected abstract void doUpdate(T var1);

    @Override
    public void remove(T attributedType) throws IdentityManagementException {
        if (attributedType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("AttributedType");
        }
        this.checkIfExists(attributedType);
        try {
            Object storedType = this.lookupById(attributedType.getClass(), attributedType.getId());
            this.removeAllAttributes((AttributedType)storedType);
            this.doRemove(attributedType);
            this.fireAttributedTypeRemovedEvent(attributedType);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeRemoveFailed((AttributedType)attributedType, e);
        }
    }

    protected abstract void fireAttributedTypeRemovedEvent(T var1);

    protected abstract void doRemove(T var1);

    protected abstract void checkUniqueness(T var1) throws IdentityManagementException;

    protected abstract void checkIfExists(T var1) throws IdentityManagementException;

    protected void fireEvent(Object event) {
        this.getEventBridge().raiseEvent(event);
    }

    protected EventBridge getEventBridge() {
        return this.getIdentityContext().getEventBridge();
    }

    protected IdentityContext createIdentityContext(Partition partition, EventBridge eventBridge, IdGenerator idGenerator) {
        return new DefaultIdentityContext(partition, eventBridge, idGenerator);
    }

    protected IdGenerator getIdGenerator() {
        return this.getIdentityContext().getIdGenerator();
    }

    protected void addAttributes(IdentityContext identityContext, AttributedType identityType) {
        Object attributeStore = this.getStoreSelector().getStoreForAttributeOperation(identityContext);
        if (attributeStore != null) {
            for (Attribute attribute : this.getAttributes(identityContext, identityType).values()) {
                attributeStore.setAttribute(identityContext, identityType, attribute);
            }
        }
    }

    protected void removeAttributes(IdentityContext identityContext, AttributedType identityType, AttributedType storedType) {
        Object attributeStore = this.getStoreSelector().getStoreForAttributeOperation(identityContext);
        if (attributeStore != null && storedType != null) {
            Map<String, Attribute> attributes = this.getAttributes(identityContext, identityType);
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                if (attributes.get(attribute.getName()) != null) continue;
                attributeStore.removeAttribute(identityContext, identityType, attribute.getName());
            }
        }
    }

    protected void removeAllAttributes(AttributedType storedType) {
        Object attributeStore = this.getStoreSelector().getStoreForAttributeOperation(this.identityContext);
        if (attributeStore != null) {
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                attributeStore.removeAttribute(this.identityContext, storedType, attribute.getName());
            }
        }
    }

    private Map<String, Attribute> getAttributes(IdentityContext identityContext, AttributedType identityType) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        for (Attribute<? extends Serializable> attribute : identityType.getAttributes()) {
            attributes.put(attribute.getName(), attribute);
        }
        List properties = PropertyQueries.createQuery(identityType.getClass()).addCriteria(new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
        for (Property property : properties) {
            AttributeProperty attributeProperty = property.getAnnotatedElement().getAnnotation(AttributeProperty.class);
            if (!attributeProperty.managed()) continue;
            String attributeName = property.getName();
            Object attributeValue = property.getValue(identityType);
            if (attributeValue != null) {
                attributes.put(attributeName, new Attribute<Serializable>(attributeName, (Serializable)attributeValue));
                continue;
            }
            attributes.remove(attributeName);
        }
        return attributes;
    }

    public StoreSelector getStoreSelector() {
        return this.configuration.getStoreSelector();
    }

    public IdentityContext getIdentityContext() {
        return this.identityContext;
    }

    protected PartitionManagerConfiguration getConfiguration() {
        return this.configuration;
    }
}

