/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractIdentityStore<C extends IdentityStoreConfiguration>
implements IdentityStore<C> {
    private C configuration;
    private Map<Class<? extends CredentialHandler>, CredentialHandler> credentialHandlers = new HashMap<Class<? extends CredentialHandler>, CredentialHandler>();

    @Override
    public void setup(C config) {
        IDMLog.IDENTITY_STORE_LOGGER.storeInitializing(this.getClass());
        this.configuration = config;
        if (IDMLog.IDENTITY_STORE_LOGGER.isDebugEnabled()) {
            IDMLog.IDENTITY_STORE_LOGGER.debugf("[%s]: [", this.configuration);
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Type: %s", this.configuration.getIdentityStoreType());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Supports partition: %s", this.configuration.supportsPartition());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Supports attribute: %s", this.configuration.supportsAttribute());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Supports credential: %s", this.configuration.supportsCredential());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Credential Handlers: %s", this.configuration.getCredentialHandlers());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Supported types: %s", this.configuration.getSupportedTypes().keySet());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Unsupported types: %s", this.configuration.getUnsupportedTypes().keySet());
            IDMLog.IDENTITY_STORE_LOGGER.debugf("  Context Initializers: %s", this.configuration.getContextInitializers());
            IDMLog.IDENTITY_STORE_LOGGER.debug("]");
        }
        if (config.supportsCredential()) {
            this.initializeCredentialHandlers();
        }
    }

    @Override
    public C getConfig() {
        return this.configuration;
    }

    @Override
    public void add(IdentityContext context, AttributedType attributedType) {
        attributedType.setId(context.getIdGenerator().generate());
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
            if (this.isTraceEnabled()) {
                IDMLog.IDENTITY_STORE_LOGGER.tracef("Type with identifier [%s] belongs to partition [%s][%s]", attributedType.getId(), context.getPartition().getName(), context.getPartition());
            }
        }
        this.addAttributedType(context, attributedType);
        if (this.isTraceEnabled()) {
            IDMLog.IDENTITY_STORE_LOGGER.tracef("Type with identifier [%s] successfully added to identity store [%s].", attributedType.getId(), this);
        }
    }

    @Override
    public void update(IdentityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
        }
        this.updateAttributedType(context, attributedType);
        if (this.isTraceEnabled()) {
            IDMLog.IDENTITY_STORE_LOGGER.tracef("Type with identifier [%s] successfully updated to identity store [%s].", attributedType.getId(), this);
        }
    }

    @Override
    public void remove(IdentityContext context, AttributedType attributedType) {
        if (IdentityType.class.isInstance(attributedType)) {
            IdentityType identityType = (IdentityType)attributedType;
            identityType.setPartition(context.getPartition());
            if (this.getConfig().supportsRelationship()) {
                this.removeFromRelationships(context, identityType);
            }
            if (Account.class.isInstance(identityType)) {
                this.removeCredentials(context, (Account)identityType);
            }
        }
        this.removeAttributedType(context, attributedType);
        if (this.isTraceEnabled()) {
            IDMLog.IDENTITY_STORE_LOGGER.tracef("Type with identifier [%s] successfully removed from identity store [%s].", attributedType.getId(), this);
        }
    }

    protected abstract void removeFromRelationships(IdentityContext var1, IdentityType var2);

    protected abstract void removeCredentials(IdentityContext var1, Account var2);

    @Override
    public void validateCredentials(IdentityContext context, Credentials credentials) {
        Class<CredentialHandler> credentialHandler = this.getCredentialHandler(credentials);
        this.credentialHandlers.get(credentialHandler).validate(context, credentials, this);
    }

    @Override
    public void updateCredential(IdentityContext context, Account account, Object credential, Date effectiveDate, Date expiryDate) {
        Class<CredentialHandler> credentialHandler = this.getCredentialHandler(credential);
        this.credentialHandlers.get(credentialHandler).update(context, account, credential, this, effectiveDate, expiryDate);
    }

    @Override
    public <V extends IdentityType> int countQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    @Override
    public <V extends Relationship> int countQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        int limit = query.getLimit();
        int offset = query.getOffset();
        query.setLimit(0);
        query.setOffset(0);
        int resultCount = query.getResultList().size();
        query.setLimit(limit);
        query.setOffset(offset);
        return resultCount;
    }

    protected void addAttributedType(IdentityContext context, AttributedType attributedType) {
    }

    protected abstract void updateAttributedType(IdentityContext var1, AttributedType var2);

    protected abstract void removeAttributedType(IdentityContext var1, AttributedType var2);

    private Class<? extends CredentialHandler> getCredentialHandler(Object credentials) {
        Class<? extends CredentialHandler> credentialHandler = null;
        if (credentialHandler == null) {
            for (Class<? extends CredentialHandler> handlerClass : this.getConfig().getCredentialHandlers()) {
                if (!handlerClass.isAnnotationPresent(SupportsCredentials.class)) continue;
                for (Class<?> cls : handlerClass.getAnnotation(SupportsCredentials.class).credentialClass()) {
                    if (!cls.isAssignableFrom(credentials.getClass())) continue;
                    credentialHandler = handlerClass;
                    if (!cls.equals(credentials.getClass())) continue;
                    return handlerClass;
                }
            }
        }
        if (credentialHandler == null) {
            throw IDMMessages.MESSAGES.credentialHandlerNotFoundForCredentialType(credentials.getClass());
        }
        return credentialHandler;
    }

    private void initializeCredentialHandlers() {
        for (Class<? extends CredentialHandler> handlerType : this.configuration.getCredentialHandlers()) {
            CredentialHandler credentialHandler = null;
            try {
                credentialHandler = handlerType.newInstance();
                credentialHandler.setup(this);
            }
            catch (Exception e) {
                throw IDMMessages.MESSAGES.instantiationError(handlerType, e);
            }
            this.credentialHandlers.put(handlerType, credentialHandler);
        }
    }

    private boolean isTraceEnabled() {
        return IDMLog.IDENTITY_STORE_LOGGER.isTraceEnabled();
    }
}

