/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.event.CredentialUpdatedEvent;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.event.IdentityTypeCreatedEvent;
import org.picketlink.idm.event.IdentityTypeDeletedEvent;
import org.picketlink.idm.event.IdentityTypeUpdatedEvent;
import org.picketlink.idm.internal.AbstractAttributedTypeManager;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.Unique;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultQueryBuilder;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.util.IDMUtil;

public class ContextualIdentityManager
extends AbstractAttributedTypeManager<IdentityType>
implements IdentityManager {
    private final DefaultPartitionManager partitionManager;
    private final RelationshipManager relationshipManager;
    private final PermissionManager permissionManager;

    public ContextualIdentityManager(Partition partition, DefaultPartitionManager partitionManager) {
        super(partitionManager.getConfiguration(), partition);
        this.partitionManager = partitionManager;
        IdentityContext identityContext = this.getIdentityContext();
        this.permissionManager = this.getStoreSelector().getStoreForPermissionOperation(identityContext) != null ? this.partitionManager.createPermissionManager(partition) : null;
        this.relationshipManager = this.partitionManager.createRelationshipManager();
    }

    @Override
    protected void doAdd(IdentityType attributedType) {
        IdentityContext identityContext = this.getIdentityContext();
        IdentityStore identityStore = this.getStoreSelector().getStoreForIdentityOperation(identityContext, IdentityStore.class, attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.create);
        identityStore.add(identityContext, attributedType);
        IDMUtil.configureDefaultPartition(identityContext, attributedType, identityStore, this.partitionManager);
    }

    @Override
    protected void fireAttributedTypeAddedEvent(IdentityType attributedType) {
        this.fireEvent(new IdentityTypeCreatedEvent(attributedType, this.partitionManager));
    }

    @Override
    protected void doUpdate(IdentityType attributedType) {
        if (attributedType.getPartition() == null) {
            throw IDMInternalMessages.MESSAGES.attributedUndefinedPartition(attributedType);
        }
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForIdentityOperation(identityContext, IdentityStore.class, attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.update).update(identityContext, attributedType);
    }

    @Override
    protected void fireAttributedTypeUpdatedEvent(IdentityType attributedType) {
        this.fireEvent(new IdentityTypeUpdatedEvent(attributedType, this.partitionManager));
    }

    @Override
    protected void fireAttributedTypeRemovedEvent(IdentityType attributedType) {
        this.fireEvent(new IdentityTypeDeletedEvent(attributedType, this.partitionManager));
    }

    @Override
    protected void doRemove(IdentityType attributedType) {
        RelationshipQuery<Relationship> query = this.relationshipManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, attributedType);
        for (Relationship relationship : query.getResultList()) {
            this.relationshipManager.remove(relationship);
        }
        if (this.permissionManager != null) {
            List<Permission> permissions = this.permissionManager.listPermissions(attributedType);
            for (Permission permission : permissions) {
                this.permissionManager.revokePermission(attributedType, permission.getResourceClass(), permission.getOperation());
            }
        }
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForIdentityOperation(identityContext, IdentityStore.class, attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.delete).remove(identityContext, attributedType);
    }

    @Override
    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        return (T)this.lookupById(identityType, id);
    }

    @Override
    public <C extends IdentityType> C lookupById(Class<C> attributedType, String id) throws IdentityManagementException {
        if (attributedType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType class");
        }
        if (id == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Identifier");
        }
        IdentityQueryBuilder queryBuilder = this.getQueryBuilder();
        IdentityQuery<C> query = queryBuilder.createIdentityQuery(attributedType);
        query.where(queryBuilder.equal(IdentityType.ID, id));
        List<C> result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw IDMInternalMessages.MESSAGES.attributedTypeAmbiguosFoundWithId(id);
            }
            identity = (IdentityType)result.get(0);
        }
        return (C)identity;
    }

    @Override
    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType class");
        }
        return new DefaultIdentityQuery<T>(this.getQueryBuilder(), this.getIdentityContext(), identityType, this.partitionManager, this.getStoreSelector());
    }

    @Override
    public void validateCredentials(Credentials credentials) {
        if (credentials == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Credentials");
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            this.getStoreSelector().getStoreForCredentialOperation(identityContext, credentials.getClass()).validateCredentials(identityContext, credentials);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialValidationFailed(credentials, e);
        }
    }

    @Override
    public void updateCredential(Account account, Object credential) {
        this.updateCredential(account, credential, null, null);
    }

    @Override
    public void updateCredential(Account account, Object credential, Date effectiveDate, Date expiryDate) {
        this.checkIfExists(account);
        if (credential == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Credential");
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            this.getStoreSelector().getStoreForCredentialOperation(identityContext, credential.getClass()).updateCredential(identityContext, account, credential, effectiveDate, expiryDate);
            this.fireEvent(new CredentialUpdatedEvent(account, credential, effectiveDate, expiryDate, this.partitionManager));
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialUpdateFailed(account, credential, e);
        }
    }

    @Override
    public <T extends CredentialStorage> T retrieveCurrentCredential(Account account, Class<T> storageClass) {
        this.checkIfExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            for (CredentialStore<?> credentialStore : this.getStoreSelector().getStoresForCredentialStorage(identityContext, storageClass)) {
                Object credentialStorage = credentialStore.retrieveCurrentCredential(identityContext, account, storageClass);
                if (credentialStorage == null) continue;
                return (T)credentialStorage;
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
        return null;
    }

    @Override
    public <T extends CredentialStorage> List<T> retrieveCredentials(Account account, Class<T> storageClass) {
        this.checkIfExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        ArrayList storages = new ArrayList();
        try {
            IdentityContext identityContext = this.getIdentityContext();
            for (CredentialStore<?> credentialStore : this.getStoreSelector().getStoresForCredentialStorage(identityContext, storageClass)) {
                storages.addAll(credentialStore.retrieveCredentials(identityContext, account, storageClass));
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
        return storages;
    }

    @Override
    public void removeCredential(Account account, Class<? extends CredentialStorage> storageClass) {
        this.checkIfExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            for (CredentialStore<?> credentialStore : this.getStoreSelector().getStoresForCredentialStorage(identityContext, storageClass)) {
                credentialStore.removeCredential(identityContext, account, storageClass);
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
    }

    @Override
    public IdentityQueryBuilder getQueryBuilder() {
        return new DefaultQueryBuilder(this.getIdentityContext(), this.partitionManager, this.getStoreSelector());
    }

    @Override
    protected IdentityContext createIdentityContext(Partition partition, EventBridge eventBridge, IdGenerator idGenerator) {
        IdentityContext identityContext = super.createIdentityContext(partition, eventBridge, idGenerator);
        identityContext.setParameter("IDENTITY_MANAGER_CTX_PARAMETER", this);
        return identityContext;
    }

    @Override
    protected void checkIfExists(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (this.lookupIdentityById(identityType.getClass(), identityType.getId()) == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeNotFoundWithId(identityType.getClass(), identityType.getId(), identityType.getPartition());
        }
    }

    @Override
    protected void checkUniqueness(IdentityType identityType) {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType");
        }
        PropertyQuery propertyQuery = PropertyQueries.createQuery(identityType.getClass());
        propertyQuery.addCriteria(new AnnotatedPropertyCriteria(Unique.class));
        IdentityQueryBuilder queryBuilder = this.getQueryBuilder();
        IdentityQuery<?> identityQuery = queryBuilder.createIdentityQuery(identityType.getClass());
        for (Property property : propertyQuery.getResultList()) {
            identityQuery.where(queryBuilder.equal(AttributedType.QUERY_ATTRIBUTE.byName(property.getName()), property.getValue(identityType)));
        }
        List<?> result = identityQuery.getResultList();
        if (!result.isEmpty()) {
            for (Property property : propertyQuery.getResultList()) {
                for (IdentityType storedType : result) {
                    if (!((Serializable)property.getValue(storedType)).equals(property.getValue(identityType))) continue;
                    throw IDMInternalMessages.MESSAGES.identityTypeAlreadyExists(identityType.getClass(), identityType.getId(), identityType.getPartition());
                }
            }
        }
    }
}

