/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.AbstractJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AttributeStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.RelationshipStorageUtil;
import org.picketlink.idm.model.AbstractAttributedType;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class RelationshipJdbcType
extends AbstractJdbcType {
    @Override
    public void delete(AttributedType attributedType) {
        RelationshipStorageUtil relationshipStorageUtil = new RelationshipStorageUtil();
        if (attributedType instanceof Grant) {
            relationshipStorageUtil.deleteGrant(this.dataSource, attributedType.getId());
        } else if (attributedType instanceof GroupMembership) {
            relationshipStorageUtil.deleteGroupMembership(this.dataSource, attributedType.getId());
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
    }

    @Override
    public void deleteRelationships(AttributedType attributedType) {
        throw new RuntimeException(attributedType.getClass().getName());
    }

    @Override
    public void persist(AttributedType attributedType) {
        RelationshipStorageUtil relationshipStorageUtil = new RelationshipStorageUtil();
        if (attributedType instanceof Grant) {
            relationshipStorageUtil.storeGrant(this.dataSource, (Grant)attributedType);
        } else if (attributedType instanceof GroupMembership) {
            relationshipStorageUtil.storeGroupMembership(this.dataSource, (GroupMembership)attributedType);
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
    }

    @Override
    public AttributedType load(String id, AttributedType attributedType) {
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }

    @Override
    public AttributedType load(String id, Class<? extends AttributedType> attributedType) {
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<? extends AttributedType> load(Map<QueryParameter, Object[]> params, Class<? extends AttributedType> attributedType) {
        ArrayList<AbstractAttributedType> result = new ArrayList<AbstractAttributedType>();
        RelationshipStorageUtil relationshipStorageUtil = new RelationshipStorageUtil();
        if (attributedType == Relationship.class) {
            Object paramValue;
            Set<QueryParameter> queryParameterSet = params.keySet();
            QueryParameter queryParameter = queryParameterSet.iterator().next();
            Object[] paramValues = params.get(queryParameter);
            if (paramValues == null && queryParameter instanceof AttributeParameter) {
                paramValues = this.getValuesFromParamMap(params, (AttributeParameter)queryParameter);
            }
            if ((paramValue = paramValues[0]) instanceof User) {
                User user = (User)paramValue;
                result.addAll(relationshipStorageUtil.loadGrantsForUser(this.dataSource, user));
                result.addAll(relationshipStorageUtil.loadGroupMembershipsForUser(this.dataSource, user));
                return result;
            } else if (paramValue instanceof Role) {
                Role role = (Role)paramValue;
                result.addAll(relationshipStorageUtil.loadGrantsForRole(this.dataSource, role));
                return result;
            } else if (paramValue instanceof Group) {
                Group group = (Group)paramValue;
                result.addAll(relationshipStorageUtil.loadGroupMembershipForGroup(this.dataSource, group));
                return result;
            } else {
                if (!(paramValue instanceof Agent)) throw IDMMessages.MESSAGES.unexpectedType(paramValue.getClass());
                Agent agent = (Agent)paramValue;
                result.addAll(relationshipStorageUtil.loadGrantsForAgent(this.dataSource, agent));
                result.addAll(relationshipStorageUtil.loadGroupMembershipsForAgent(this.dataSource, agent));
            }
            return result;
        } else if (attributedType == Grant.class) {
            Set<QueryParameter> queryParameterSet = params.keySet();
            QueryParameter queryParameter = queryParameterSet.iterator().next();
            Object[] paramValues = params.get(queryParameter);
            if (paramValues == null && queryParameter instanceof AttributeParameter) {
                paramValues = this.getValuesFromParamMap(params, (AttributeParameter)queryParameter);
            }
            if (paramValues == null) {
                throw IDMMessages.MESSAGES.nullArgument("paramValues");
            }
            Object paramValue = paramValues[0];
            if (paramValue instanceof User) {
                User user = (User)paramValue;
                result.addAll(relationshipStorageUtil.loadGrantsForUser(this.dataSource, user));
                return result;
            } else if (paramValue instanceof Role) {
                Role role = (Role)paramValue;
                result.addAll(relationshipStorageUtil.loadGrantsForRole(this.dataSource, role));
                return result;
            } else {
                if (queryParameter != IdentityType.ID) throw IDMMessages.MESSAGES.unexpectedType(paramValue.getClass());
                Object[] idObj = params.get(IdentityType.ID);
                String idOfType = (String)idObj[0];
                RelationshipStorageUtil relationshipStorageUtil1 = new RelationshipStorageUtil();
                Grant grant = relationshipStorageUtil.loadGrant(this.dataSource, idOfType);
                if (grant == null) return result;
                result.add(grant);
            }
            return result;
        } else {
            Object paramValue;
            if (attributedType != GroupMembership.class) throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
            Set<QueryParameter> queryParameterSet = params.keySet();
            QueryParameter queryParameter = queryParameterSet.iterator().next();
            Object[] paramValues = params.get(queryParameter);
            if (paramValues == null && queryParameter instanceof AttributeParameter) {
                paramValues = this.getValuesFromParamMap(params, (AttributeParameter)queryParameter);
            }
            if ((paramValue = paramValues[0]) instanceof User) {
                User user = (User)paramValue;
                result.addAll(relationshipStorageUtil.loadGroupMembershipsForUser(this.dataSource, user));
                return result;
            } else if (paramValue instanceof Group) {
                Group group = (Group)paramValue;
                result.addAll(relationshipStorageUtil.loadGroupMembershipForGroup(this.dataSource, group));
                return result;
            } else {
                if (queryParameter != IdentityType.ID) throw IDMMessages.MESSAGES.unexpectedType(paramValue.getClass());
                Object[] idObj = params.get(IdentityType.ID);
                String idOfType = (String)idObj[0];
                RelationshipStorageUtil relationshipStorageUtil1 = new RelationshipStorageUtil();
                GroupMembership groupMembership = relationshipStorageUtil.loadGroupMembership(this.dataSource, idOfType);
                if (groupMembership == null) return result;
                result.add(groupMembership);
            }
        }
        return result;
    }

    @Override
    public void update(AttributedType attributedType) {
        throw new RuntimeException();
    }

    @Override
    public void setAttribute(Attribute<? extends Serializable> attribute) {
        throw IDMMessages.MESSAGES.unexpectedType(attribute.getClass());
    }

    @Override
    public void removeAttribute(String name) {
        throw new RuntimeException();
    }

    @Override
    public <T extends Serializable> Attribute<T> getAttribute(String name) {
        throw new RuntimeException();
    }

    @Override
    public Collection<Attribute<? extends Serializable>> getAttributes() {
        ArrayList<Attribute<? extends Serializable>> list = new ArrayList<Attribute<? extends Serializable>>();
        AttributeStorageUtil attributeStorageUtil = new AttributeStorageUtil();
        List<Attribute> attributeList = attributeStorageUtil.getAttributes(this.dataSource, this.id);
        if (!attributeList.isEmpty()) {
            for (Attribute att : attributeList) {
                list.add(att);
            }
        }
        return list;
    }
}

