/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.AttributeStorageUtil;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class GroupStorageUtil
extends AbstractStorageUtil {
    public void deleteGroup(DataSource dataSource, Group group) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from Groups where id=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, group.getId());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete group failed for name=" + group.getName());
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public Group loadGroup(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            Group group;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select name,partitionID,parentGroup,path,enabled,createdDate,expirationDate from Groups where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                Group group2 = new Group();
                group2.setName(resultSet.getString(1));
                group2.setId(id);
                group2.setPartition(this.loadPartition(dataSource, resultSet.getString(2)));
                group2.setParentGroup(this.loadGroup(dataSource, resultSet.getString(3)));
                group2.setPath(resultSet.getString(4));
                group2.setEnabled("y".equalsIgnoreCase(resultSet.getString(5)));
                Timestamp creationDate = resultSet.getTimestamp(6);
                if (creationDate != null) {
                    group2.setCreatedDate(new Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(7)) != null) {
                    group2.setExpirationDate(new Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, id)).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        group2.setAttribute(attribute);
                    }
                }
                group = group2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return group;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public Group loadGroup(DataSource dataSource, Map<QueryParameter, Object[]> params) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Set<QueryParameter> queryParameters = params.keySet();
        for (QueryParameter queryParameter : queryParameters) {
            if (!(queryParameter instanceof AttributeParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            Object[] paramValues = this.getValuesFromParamMap(params, attributeParameter);
            String attributeName = attributeParameter.getName();
            if ("name".equals(attributeName)) {
                String loginNameValue = (String)paramValues[0];
                return this.loadGroupByName(dataSource, loginNameValue);
            }
            if ("path".equals(attributeName)) {
                String loginNameValue = (String)paramValues[0];
                return this.loadGroupByPath(dataSource, loginNameValue);
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    public Group loadGroupByName(DataSource dataSource, String groupName) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            Group group;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select id,partitionID,parentGroup,path,enabled,createdDate,expirationDate from Groups where name =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, groupName);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                Group group2 = new Group();
                group2.setId(resultSet.getString(1));
                group2.setName(groupName);
                group2.setPartition(this.loadPartition(dataSource, resultSet.getString(2)));
                group2.setParentGroup(this.loadGroup(dataSource, resultSet.getString(3)));
                group2.setPath(resultSet.getString(4));
                group2.setEnabled("y".equalsIgnoreCase(resultSet.getString(5)));
                Timestamp creationDate = resultSet.getTimestamp(6);
                if (creationDate != null) {
                    group2.setCreatedDate(new Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(7)) != null) {
                    group2.setExpirationDate(new Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, group2.getId())).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        group2.setAttribute(attribute);
                    }
                }
                group = group2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return group;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public Group loadGroupByPath(DataSource dataSource, String path) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            Group group;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select id,name,partitionID,parentGroup,enabled,createdDate,expirationDate from Groups where path =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, path);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                Group group2 = new Group();
                group2.setId(resultSet.getString(1));
                group2.setName(resultSet.getString(2));
                group2.setPartition(this.loadPartition(dataSource, resultSet.getString(3)));
                group2.setParentGroup(this.loadGroup(dataSource, resultSet.getString(4)));
                group2.setPath(path);
                group2.setEnabled("y".equalsIgnoreCase(resultSet.getString(5)));
                Timestamp creationDate = resultSet.getTimestamp(6);
                if (creationDate != null) {
                    group2.setCreatedDate(new Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(7)) != null) {
                    group2.setExpirationDate(new Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, group2.getId())).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        group2.setAttribute(attribute);
                    }
                }
                group = group2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return group;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public void storeGroup(DataSource dataSource, Group group) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "insert into Groups set name=?,id=?,createdDate=?,expirationDate=?,partitionID=?,parentGroup=?,path=?,enabled=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, group.getName());
            preparedStatement.setString(2, group.getId());
            preparedStatement.setTimestamp(3, new Timestamp(group.getCreatedDate().getTime()));
            if (group.getExpirationDate() != null) {
                preparedStatement.setTimestamp(4, new Timestamp(group.getExpirationDate().getTime()));
            } else {
                preparedStatement.setTimestamp(4, null);
            }
            preparedStatement.setString(5, group.getPartition().getId());
            if (group.getParentGroup() == null) {
                preparedStatement.setString(6, null);
            } else {
                preparedStatement.setString(6, group.getParentGroup().getId());
            }
            preparedStatement.setString(7, group.getPath());
            if (group.isEnabled()) {
                preparedStatement.setString(8, "y");
            } else {
                preparedStatement.setString(8, "n");
            }
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Insert into Group failed");
            }
            PartitionJdbcType pj = new PartitionJdbcType("dummy");
            pj.setDataSource(dataSource);
            pj.persist(group.getPartition());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void updateGroup(DataSource dataSource, Group group) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        String updateSql = "update Groups set name=?,parentGroup=?,partitionID=?,enabled=?,createdDate=?,expirationDate=? where id =?";
        if (group.getExpirationDate() == null) {
            updateSql = "update Groups set name=?,parentGroup=?,partitionID=?,enabled=?,createdDate=? where id =?";
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setString(1, group.getName());
            if (group.getParentGroup() == null) {
                preparedStatement.setString(2, null);
            } else {
                preparedStatement.setString(2, group.getParentGroup().getId());
            }
            if (group.getPartition() == null) {
                preparedStatement.setString(3, null);
            } else {
                preparedStatement.setString(3, group.getPartition().getId());
            }
            if (group.isEnabled()) {
                preparedStatement.setString(4, "y");
            } else {
                preparedStatement.setString(4, "n");
            }
            preparedStatement.setTimestamp(5, new Timestamp(group.getCreatedDate().getTime()));
            if (group.getExpirationDate() != null) {
                preparedStatement.setTimestamp(6, new Timestamp(group.getExpirationDate().getTime()));
                preparedStatement.setString(7, group.getId());
            } else {
                preparedStatement.setString(6, group.getId());
            }
            int numberOfRows = preparedStatement.executeUpdate();
            if (numberOfRows == 0) {
                System.out.println("Update Group failed");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
    }
}

