/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPUtil;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.Condition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.query.internal.BetweenCondition;
import org.picketlink.idm.query.internal.EqualCondition;
import org.picketlink.idm.query.internal.GreaterThanCondition;
import org.picketlink.idm.query.internal.InCondition;
import org.picketlink.idm.query.internal.LessThanCondition;
import org.picketlink.idm.query.internal.LikeCondition;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
extends AbstractIdentityStore<LDAPIdentityStoreConfiguration>
implements CredentialStore<LDAPIdentityStoreConfiguration> {
    public static final String EMPTY_ATTRIBUTE_VALUE = " ";
    public static final String ENTRY_DN_ATTRIBUTE_NAME = "org.picketlink.idm.ldap.entry.dn";
    private LDAPOperationManager operationManager;

    @Override
    public void setup(LDAPIdentityStoreConfiguration config) {
        super.setup(config);
        if (config.isActiveDirectory()) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapActiveDirectoryConfiguration();
        }
        try {
            this.operationManager = new LDAPOperationManager((LDAPIdentityStoreConfiguration)this.getConfig());
        }
        catch (NamingException e) {
            throw IDMInternalMessages.MESSAGES.storeLdapCouldNotCreateContext(e);
        }
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        attributedType.setId(null);
        if (Relationship.class.isInstance(attributedType)) {
            this.addRelationship((Relationship)attributedType);
        } else {
            this.operationManager.createSubContext(this.getBindingDN(attributedType, true), this.extractAttributes(attributedType, true));
            this.addToParentAsMember(attributedType);
            attributedType.setId(this.getEntryIdentifier(attributedType));
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapRelationshipUpdateNotSupported(attributedType);
        } else {
            BasicAttributes updatedAttributes = this.extractAttributes(attributedType, false);
            NamingEnumeration<javax.naming.directory.Attribute> attributes = updatedAttributes.getAll();
            this.operationManager.modifyAttributes(this.getBindingDN(attributedType, true), attributes);
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.removeRelationship((Relationship)attributedType);
        } else {
            LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
            this.operationManager.removeEntryById(this.getBaseDN(attributedType), attributedType.getId(), mappingConfig);
        }
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
        String bindingDN = this.getBindingDN(identityType, true);
        for (LDAPMappingConfiguration relationshipConfig : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
            for (String attributeName : relationshipConfig.getMappedProperties().values()) {
                StringBuilder filter = new StringBuilder();
                filter.append("(&(").append(attributeName).append("=").append("").append(bindingDN).append("))");
                try {
                    List<SearchResult> search = this.operationManager.search(this.getMappingConfig(relationshipConfig.getRelatedAttributedType()).getBaseDN(), filter.toString(), this.getMappingConfig(relationshipConfig.getRelatedAttributedType()));
                    for (SearchResult result : search) {
                        Attributes attributes = result.getAttributes();
                        javax.naming.directory.Attribute relationshipAttribute = attributes.get(attributeName);
                        if (relationshipAttribute == null || !relationshipAttribute.contains(bindingDN)) continue;
                        relationshipAttribute.remove(bindingDN);
                        if (relationshipAttribute.size() == 0) {
                            relationshipAttribute.add(EMPTY_ATTRIBUTE_VALUE);
                        }
                        this.operationManager.modifyAttribute(result.getNameInNamespace(), relationshipAttribute);
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException("Could not remove " + identityType + " from relationship " + relationshipConfig.getMappedClass(), e);
                }
            }
        }
    }

    @Override
    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList<IdentityType> results = new ArrayList<IdentityType>();
        try {
            if (identityQuery.getSorting() != null && !identityQuery.getSorting().isEmpty()) {
                throw new IdentityManagementException("LDAP Identity Store does not support sorted queries.");
            }
            for (Condition condition : identityQuery.getConditions()) {
                if (identityQuery.getConditions().size() == 1 && IdentityType.PARTITION.equals(condition.getParameter())) {
                    return results;
                }
                if (!IdentityType.ID.equals(condition.getParameter())) continue;
                if (EqualCondition.class.isInstance(condition)) {
                    EqualCondition equalCondition = (EqualCondition)condition;
                    SearchResult search = this.operationManager.lookupById(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), equalCondition.getValue().toString(), null);
                    if (search != null) {
                        results.add((IdentityType)this.populateAttributedType(search, null));
                    }
                }
                return results;
            }
            if (!IdentityType.class.equals(identityQuery.getIdentityType())) {
                LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(identityQuery.getIdentityType());
                StringBuilder filter = this.createIdentityTypeSearchFilter(identityQuery, ldapEntryConfig);
                String baseDN = this.getBaseDN(ldapEntryConfig);
                List<SearchResult> search = ((LDAPIdentityStoreConfiguration)this.getConfig()).isPagination() && identityQuery.getLimit() > 0 ? this.operationManager.searchPaginated(baseDN, filter.toString(), ldapEntryConfig, identityQuery) : this.operationManager.search(baseDN, filter.toString(), ldapEntryConfig);
                for (SearchResult result : search) {
                    if (result.getNameInNamespace().equals(baseDN)) continue;
                    results.add((IdentityType)this.populateAttributedType(result, null));
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryIdentityTypeFailed(identityQuery, e);
        }
        return results;
    }

    @Override
    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        ArrayList<V> results = new ArrayList<V>();
        if (Relationship.class.equals(query.getRelationshipClass())) {
            for (LDAPMappingConfiguration configuration : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
                results.addAll(this.fetchRelationships(query, configuration));
            }
        } else {
            results.addAll(this.fetchRelationships(query, this.getMappingConfig(query.getRelationshipClass())));
        }
        return results;
    }

    private String getRelationshipMappedProperty(Class<? extends IdentityType> identityType, LDAPMappingConfiguration mappingConfig) {
        Property property = PropertyQueries.createQuery(mappingConfig.getMappedClass()).addCriteria(new TypedPropertyCriteria(identityType, TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
        if (property == null) {
            return null;
        }
        return mappingConfig.getMappedProperties().get(property.getName());
    }

    private <V extends Relationship> List<V> fetchRelationships(RelationshipQuery<V> query, LDAPMappingConfiguration mappingConfig) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        Class<? extends AttributedType> relationshipClass = mappingConfig.getMappedClass();
        Map<QueryParameter, Object[]> parameters = query.getParameters();
        LDAPMappingConfiguration relatedTypeConfig = this.getMappingConfig(mappingConfig.getRelatedAttributedType());
        StringBuilder filter = new StringBuilder();
        filter.append("(&").append((CharSequence)this.getObjectClassesFilter(relatedTypeConfig));
        ArrayList<String> entriesToFilter = new ArrayList<String>();
        for (QueryParameter queryParameter : parameters.keySet()) {
            Object[] values = parameters.get(queryParameter);
            RelationshipQueryParameter relationshipQueryParameter = null;
            String attributeName = null;
            if (RelationshipQueryParameter.class.isInstance(queryParameter)) {
                relationshipQueryParameter = (RelationshipQueryParameter)queryParameter;
                attributeName = mappingConfig.getMappedProperties().get(relationshipQueryParameter.getName());
            } else {
                if (!Relationship.IDENTITY.equals(queryParameter)) continue;
                IdentityType identityType = (IdentityType)values[0];
                if (!mappingConfig.getRelatedAttributedType().isInstance(identityType)) {
                    attributeName = this.getRelationshipMappedProperty(identityType.getClass(), mappingConfig);
                }
            }
            for (Object value : values) {
                Property property;
                AttributedType attributedType = (AttributedType)value;
                if (!((LDAPIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.read)) {
                    return results;
                }
                String bindingDN = null;
                SearchResult result = this.operationManager.lookupById(this.getBaseDN(attributedType), attributedType.getId(), this.getMappingConfig(attributedType.getClass()));
                if (result != null) {
                    bindingDN = result.getNameInNamespace();
                    if (!attributedType.getClass().equals(relatedTypeConfig.getMappedClass())) {
                        entriesToFilter.add(bindingDN);
                    }
                }
                boolean filterByOwner = attributedType.getClass().equals(relatedTypeConfig.getMappedClass());
                if (attributeName != null && (property = PropertyQueries.createQuery(relationshipClass).addCriteria(new NamedPropertyCriteria(attributeName)).getFirstResult()) != null) {
                    filterByOwner = property.getJavaClass().equals(relatedTypeConfig.getMappedClass());
                }
                if (filterByOwner) {
                    filter.append(this.operationManager.getFilterById(this.getBaseDN(attributedType), attributedType.getId()));
                    continue;
                }
                filter.append("(").append(attributeName).append("=").append(bindingDN).append(")");
            }
        }
        filter.append(")");
        try {
            if (filter.length() > 0) {
                String baseDN = this.getBaseDN(relatedTypeConfig);
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Search relationships for type [%s] using filter [%s] and baseDN [%s]", relationshipClass, filter.toString(), baseDN);
                }
                List<SearchResult> search = this.operationManager.search(baseDN, filter.toString(), relatedTypeConfig);
                for (SearchResult entry : search) {
                    if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found entry [%s] for relationship type [%s].", entry.getNameInNamespace(), relationshipClass);
                    }
                    Attributes ownerAttributes = entry.getAttributes();
                    AttributedType ownerType = this.populateAttributedType(entry, null);
                    for (Map.Entry<String, String> memberAttribute : mappingConfig.getMappedProperties().entrySet()) {
                        String attributeName = memberAttribute.getValue();
                        javax.naming.directory.Attribute attribute = ownerAttributes.get(attributeName);
                        if (attribute == null) continue;
                        NamingEnumeration<?> attributeValues = attribute.getAll();
                        while (attributeValues.hasMore()) {
                            String dn;
                            String attributeValue = attributeValues.next().toString();
                            if (!entriesToFilter.isEmpty() && !entriesToFilter.contains(attributeValue)) continue;
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Processing relationship [%s] from attribute [%s] with attributeValue [%s].", relationshipClass, attributeName, attributeValue);
                            }
                            if (StringUtil.isNullOrEmpty(attributeValue.trim())) continue;
                            Property<AttributedType> associatedProperty = PropertyQueries.createQuery(relationshipClass).addCriteria(new NamedPropertyCriteria(memberAttribute.getKey())).getSingleResult();
                            String memberBaseDN = attributeValue.substring(attributeValue.indexOf(",") + 1);
                            List<SearchResult> result = this.operationManager.search(memberBaseDN, dn = attributeValue.substring(0, attributeValue.indexOf(",")), null);
                            if (result.isEmpty()) {
                                throw new IdentityManagementException("Associated entry does not exists [" + attributeValue + "].");
                            }
                            Property<AttributedType> property = PropertyQueries.createQuery(relationshipClass).addCriteria(new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
                            if (!property.getJavaClass().isAssignableFrom(ownerType.getClass())) continue;
                            Relationship relationship = (Relationship)Reflections.newInstance(relationshipClass);
                            property.setValue(relationship, ownerType);
                            SearchResult member = result.get(0);
                            AttributedType relType = this.populateAttributedType(member, null);
                            if (!associatedProperty.getJavaClass().isAssignableFrom(relType.getClass())) continue;
                            associatedProperty.setValue(relationship, relType);
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Relationship [%s] created from attribute [%s] with attributeValue [%s].", relationshipClass, attributeName, attributeValue);
                            }
                            results.add(relationship);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryRelationshipFailed(query, e);
        }
        return results;
    }

    @Override
    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
    }

    @Override
    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    @Override
    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    @Override
    public void removeCredential(IdentityContext context, Account account, Class<? extends CredentialStorage> storageClass) {
        throw IDMInternalMessages.MESSAGES.notImplemented();
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
    }

    private String getBaseDN(LDAPMappingConfiguration ldapEntryConfig) {
        String baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        if (ldapEntryConfig.getBaseDN() != null) {
            baseDN = ldapEntryConfig.getBaseDN();
        }
        return baseDN;
    }

    protected <V extends IdentityType> StringBuilder createIdentityTypeSearchFilter(IdentityQuery<V> identityQuery, LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder filter = new StringBuilder();
        for (Condition condition : identityQuery.getConditions()) {
            Object parameterValue;
            QueryParameter queryParameter = condition.getParameter();
            if (IdentityType.ID.equals(queryParameter) || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            String attributeName = ldapEntryConfig.getMappedProperties().get(attributeParameter.getName());
            if (attributeName == null) continue;
            if (EqualCondition.class.isInstance(condition)) {
                EqualCondition equalCondition = (EqualCondition)condition;
                parameterValue = equalCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                filter.append("(").append(attributeName).append("=").append(parameterValue).append(")");
                continue;
            }
            if (LikeCondition.class.isInstance(condition)) {
                LikeCondition likeCondition = (LikeCondition)condition;
                parameterValue = (String)likeCondition.getValue();
                continue;
            }
            if (GreaterThanCondition.class.isInstance(condition)) {
                GreaterThanCondition greaterThanCondition = (GreaterThanCondition)condition;
                parameterValue = greaterThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (greaterThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append(">=").append(parameterValue).append(")");
                    continue;
                }
                filter.append("(").append(attributeName).append(">").append(parameterValue).append(")");
                continue;
            }
            if (LessThanCondition.class.isInstance(condition)) {
                LessThanCondition lessThanCondition = (LessThanCondition)condition;
                parameterValue = lessThanCondition.getValue();
                if (Date.class.isInstance(parameterValue)) {
                    parameterValue = LDAPUtil.formatDate((Date)parameterValue);
                }
                if (lessThanCondition.isOrEqual()) {
                    filter.append("(").append(attributeName).append("<=").append(parameterValue).append(")");
                    continue;
                }
                filter.append("(").append(attributeName).append("<").append(parameterValue).append(")");
                continue;
            }
            if (BetweenCondition.class.isInstance(condition)) {
                BetweenCondition betweenCondition = (BetweenCondition)condition;
                Object x = betweenCondition.getX();
                Object y = betweenCondition.getY();
                if (Date.class.isInstance(x)) {
                    x = LDAPUtil.formatDate((Date)x);
                }
                if (Date.class.isInstance(y)) {
                    y = LDAPUtil.formatDate((Date)y);
                }
                filter.append("(").append(x).append("<=").append(attributeName).append("<=").append(y).append(")");
                continue;
            }
            if (InCondition.class.isInstance(condition)) {
                InCondition inCondition = (InCondition)condition;
                Object[] valuesToCompare = inCondition.getValue();
                filter.append("(&(");
                for (int i = 0; i < valuesToCompare.length; ++i) {
                    Object value = valuesToCompare[i];
                    filter.append("(").append(attributeName).append("=").append(value).append(")");
                }
                filter.append("))");
                continue;
            }
            throw new IdentityManagementException("Unsupported query condition [" + condition + "].");
        }
        filter.insert(0, "(&(");
        filter.append((CharSequence)this.getObjectClassesFilter(ldapEntryConfig));
        filter.append("))");
        return filter;
    }

    private StringBuilder getObjectClassesFilter(LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder builder = new StringBuilder();
        if (ldapEntryConfig != null && !ldapEntryConfig.getObjectClasses().isEmpty()) {
            for (String objectClass : ldapEntryConfig.getObjectClasses()) {
                builder.append("(").append("objectclass").append("=").append(objectClass).append(")");
            }
        } else {
            builder.append("(").append("objectclass").append("=").append("*").append(")");
        }
        return builder;
    }

    private void addRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes entryAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String relationshipTypeProperty : mappingConfig.getMappedProperties().keySet()) {
            Property relationshipProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new NamedPropertyCriteria(relationshipTypeProperty)).getSingleResult();
            javax.naming.directory.Attribute attribute = entryAttributes.get(mappingConfig.getMappedProperties().get(relationshipTypeProperty));
            if (attribute == null) continue;
            ArrayList<String> membersToRemove = new ArrayList<String>();
            String memberDN = this.getBindingDN((AttributedType)relationshipProperty.getValue(relationship), true);
            try {
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object value = attributeValues.next();
                    if (value.toString().trim().equals(EMPTY_ATTRIBUTE_VALUE.trim())) {
                        membersToRemove.add(EMPTY_ATTRIBUTE_VALUE);
                        membersToRemove.add(EMPTY_ATTRIBUTE_VALUE.trim());
                    }
                    if (!value.toString().toLowerCase().equals(memberDN.toLowerCase())) continue;
                    membersToRemove.add(value.toString());
                }
                for (String memberToRemove : membersToRemove) {
                    attribute.remove(memberToRemove);
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not iterate over members for relationship [" + relationship + "].", ne);
            }
            attribute.add(memberDN);
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType, true), attribute);
        }
    }

    private AttributedType getRelationshipOwner(Relationship relationship) {
        Class<? extends AttributedType> ownertType = this.getMappingConfig(relationship.getClass()).getRelatedAttributedType();
        Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new TypedPropertyCriteria(ownertType)).getSingleResult();
        return (AttributedType)property.getValue(relationship);
    }

    private void removeRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes ownerAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String typeProperty : mappingConfig.getMappedProperties().keySet()) {
            Property relProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new NamedPropertyCriteria(typeProperty)).getSingleResult();
            javax.naming.directory.Attribute mappedAttribute = ownerAttributes.get(mappingConfig.getMappedProperties().get(typeProperty));
            if (mappedAttribute != null) {
                String childDN = this.getBindingDN((AttributedType)relProperty.getValue(relationship), true);
                NamingEnumeration<?> members = null;
                try {
                    members = mappedAttribute.getAll();
                    while (members.hasMoreElements()) {
                        Object next = members.next();
                        if (!next.toString().equalsIgnoreCase(childDN)) continue;
                        mappedAttribute.remove(next);
                    }
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Could not remove relationship [" + relationship + "].", e);
                }
                finally {
                    if (members != null) {
                        try {
                            members.close();
                        }
                        catch (NamingException ignore) {}
                    }
                }
            }
            if (mappedAttribute == null) continue;
            if (mappedAttribute.size() == 0) {
                mappedAttribute.add(EMPTY_ATTRIBUTE_VALUE);
            }
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType, true), mappedAttribute);
        }
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType) {
        return this.populateAttributedType(searchResult, attributedType, 0);
    }

    private AttributedType populateAttributedType(SearchResult searchResult, AttributedType attributedType, int hierarchyDepthCount) {
        try {
            String entryDN = searchResult.getNameInNamespace();
            Attributes attributes = searchResult.getAttributes();
            if (attributedType == null) {
                attributedType = Reflections.newInstance(((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(entryDN, this.getEntryObjectClasses(attributes)));
            }
            attributedType.setAttribute(new Attribute<String>(ENTRY_DN_ATTRIBUTE_NAME, entryDN));
            LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
            if (hierarchyDepthCount > mappingConfig.getHierarchySearchDepth()) {
                return null;
            }
            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating attributed type [%s] from DN [%s]", attributedType, entryDN);
            }
            NamingEnumeration<? extends javax.naming.directory.Attribute> ldapAttributes = attributes.getAll();
            while (ldapAttributes.hasMore()) {
                Object attributeValue;
                javax.naming.directory.Attribute ldapAttribute = ldapAttributes.next();
                try {
                    attributeValue = ldapAttribute.get();
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                String ldapAttributeName = ldapAttribute.getID();
                if (ldapAttributeName.toLowerCase().equals(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName().toLowerCase())) {
                    attributedType.setId(this.operationManager.decodeEntryUUID(attributeValue));
                    continue;
                }
                String attributeName = this.findAttributeName(mappingConfig.getMappedProperties(), ldapAttributeName);
                if (attributeName == null) continue;
                Property<Object> property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new NamedPropertyCriteria(attributeName)).getFirstResult();
                if (property != null) {
                    if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating property [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{property.getName(), ldapAttributeName, attributeValue, entryDN});
                    }
                    if (property.getJavaClass().equals(Date.class)) {
                        property.setValue(attributedType, LDAPUtil.parseDate(attributeValue.toString()));
                        continue;
                    }
                    property.setValue(attributedType, attributeValue);
                    continue;
                }
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating attribute [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{attributeName, ldapAttributeName, attributeValue, entryDN});
                }
                attributedType.setAttribute(new Attribute<Serializable>(attributeName, (Serializable)attributeValue));
            }
            if (IdentityType.class.isInstance(attributedType)) {
                IdentityType identityType = (IdentityType)attributedType;
                String createdTimestamp = attributes.get("createTimeStamp").get().toString();
                identityType.setCreatedDate(LDAPUtil.parseDate(createdTimestamp));
            }
            LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
            if (mappingConfig.getParentMembershipAttributeName() != null) {
                List<SearchResult> search;
                StringBuilder filter = new StringBuilder("(&");
                String entryBaseDN = entryDN.substring(entryDN.indexOf(",") + 1);
                filter.append("(").append((CharSequence)this.getObjectClassesFilter(entryConfig)).append(")").append("(").append(mappingConfig.getParentMembershipAttributeName()).append("=").append("").append(this.getBindingDN(attributedType, false)).append(",").append(entryBaseDN).append(")");
                filter.append(")");
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Searching parent entry for DN [%s] using filter [%s].", entryBaseDN, filter.toString());
                }
                if (!(search = this.operationManager.search(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), filter.toString(), entryConfig)).isEmpty()) {
                    SearchResult next = search.get(0);
                    Property<AttributedType> parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
                    if (parentProperty != null) {
                        String parentDN = next.getNameInNamespace();
                        String parentBaseDN = parentDN.substring(parentDN.indexOf(",") + 1);
                        Class<? extends AttributedType> baseDNType = ((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(parentBaseDN, this.getEntryObjectClasses(attributes));
                        if (parentProperty.getJavaClass().isAssignableFrom(baseDNType)) {
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found parent [%s] for entry for DN [%s].", parentDN, entryDN);
                            }
                            int hierarchyDepthCount1 = ++hierarchyDepthCount;
                            parentProperty.setValue(attributedType, this.populateAttributedType(next, null, hierarchyDepthCount1));
                        }
                    }
                } else if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("No parent entry found for DN [%s] using filter [%s].", entryDN, filter.toString());
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not populate attribute type " + attributedType + ".", e);
        }
        return attributedType;
    }

    private String findAttributeName(Map<String, String> attrMapping, String ldapAttributeName) {
        for (Map.Entry<String, String> currentAttr : attrMapping.entrySet()) {
            if (!currentAttr.getValue().equalsIgnoreCase(ldapAttributeName)) continue;
            return currentAttr.getKey();
        }
        return null;
    }

    private List<String> getEntryObjectClasses(Attributes attributes) throws NamingException {
        javax.naming.directory.Attribute objectClassesAttribute = attributes.get("objectclass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        if (objectClassesAttribute == null) {
            return objectClasses;
        }
        NamingEnumeration<?> all = objectClassesAttribute.getAll();
        while (all.hasMore()) {
            objectClasses.add(all.next().toString());
        }
        return objectClasses;
    }

    protected BasicAttributes extractAttributes(AttributedType attributedType, boolean isCreate) {
        BasicAttributes entryAttributes = new BasicAttributes();
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Map<String, String> mappedProperties = mappingConfig.getMappedProperties();
        for (String propertyName : mappedProperties.keySet()) {
            if (mappingConfig.getReadOnlyAttributes().contains(propertyName) || !isCreate && mappingConfig.getBindingProperty().getName().equals(propertyName)) continue;
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new NamedPropertyCriteria(propertyName)).getFirstResult();
            Object propertyValue = null;
            if (property != null) {
                propertyValue = property.getValue(attributedType);
            } else {
                Attribute attribute = attributedType.getAttribute(propertyName);
                if (attribute != null) {
                    propertyValue = attribute.getValue();
                }
            }
            if (AttributedType.class.isInstance(propertyValue)) {
                AttributedType referencedType = (AttributedType)propertyValue;
                propertyValue = this.getBindingDN(referencedType, true);
            } else if (propertyValue == null || StringUtil.isNullOrEmpty(propertyValue.toString())) {
                propertyValue = EMPTY_ATTRIBUTE_VALUE;
            }
            entryAttributes.put(mappedProperties.get(propertyName), propertyValue);
        }
        if (isCreate) {
            LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(attributedType.getClass());
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            for (String objectClassValue : ldapEntryConfig.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
                if (!objectClassValue.equals("groupOfNames") && !objectClassValue.equals("groupOfEntries") && !objectClassValue.equals("groupOfUniqueNames")) continue;
                entryAttributes.put("member", EMPTY_ATTRIBUTE_VALUE);
            }
            entryAttributes.put(objectClassAttribute);
        }
        return entryAttributes;
    }

    private LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfiguration mappingConfig = ((LDAPIdentityStoreConfiguration)this.getConfig()).getMappingConfig(attributedType);
        if (mappingConfig == null) {
            throw new IdentityManagementException("Not mapped type [" + attributedType + "].");
        }
        return mappingConfig;
    }

    public LDAPOperationManager getOperationManager() {
        return this.operationManager;
    }

    public String getBindingDN(AttributedType attributedType, boolean appendBaseDN) {
        String dn;
        String bindingAttribute;
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property<String> idProperty = mappingConfig.getIdProperty();
        String baseDN = mappingConfig.getBaseDN() == null || !appendBaseDN ? "" : "," + this.getBaseDN(attributedType);
        Property<String> bindingProperty = mappingConfig.getBindingProperty();
        if (bindingProperty == null) {
            bindingAttribute = mappingConfig.getMappedProperties().get(idProperty.getName());
            dn = idProperty.getValue(attributedType);
        } else {
            bindingAttribute = mappingConfig.getMappedProperties().get(bindingProperty.getName());
            dn = mappingConfig.getBindingProperty().getValue(attributedType);
        }
        return bindingAttribute + "=" + dn + baseDN;
    }

    public String getBindingDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        if (attributedType.getId() != null) {
            SearchResult searchResult;
            String baseDN = mappingConfig.getBaseDN();
            if (baseDN == null) {
                baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
            }
            if ((searchResult = this.operationManager.lookupById(baseDN, attributedType.getId(), mappingConfig)) == null) {
                throw IDMInternalMessages.MESSAGES.storeLdapEntryNotFoundWithId(attributedType.getId(), baseDN);
            }
            return searchResult.getNameInNamespace();
        }
        return this.getBindingDN(attributedType, true);
    }

    private String getBaseDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        String baseDN = mappingConfig.getBaseDN();
        String parentDN = mappingConfig.getParentMapping().get(mappingConfig.getIdProperty().getValue(attributedType));
        if (parentDN != null) {
            baseDN = parentDN;
        } else {
            AttributedType parentType;
            Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
            if (parentProperty != null && (parentType = (AttributedType)parentProperty.getValue(attributedType)) != null) {
                Property<String> parentIdProperty = this.getMappingConfig(parentType.getClass()).getIdProperty();
                String parentId = parentIdProperty.getValue(parentType);
                String parentBaseDN = mappingConfig.getParentMapping().get(parentId);
                baseDN = parentBaseDN != null ? parentBaseDN : this.getBaseDN(parentType);
            }
        }
        if (baseDN == null) {
            baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        }
        return baseDN;
    }

    protected void addToParentAsMember(AttributedType attributedType) {
        AttributedType parentType;
        Property parentProperty;
        LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
        if (entryConfig.getParentMembershipAttributeName() != null && (parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria(new TypedPropertyCriteria(attributedType.getClass())).getFirstResult()) != null && (parentType = (AttributedType)parentProperty.getValue(attributedType)) != null) {
            Attributes attributes = this.operationManager.getAttributes(parentType.getId(), this.getBaseDN(parentType), entryConfig);
            javax.naming.directory.Attribute attribute = attributes.get(entryConfig.getParentMembershipAttributeName());
            attribute.add(this.getBindingDN(attributedType, true));
            this.operationManager.modifyAttribute(this.getBindingDN(parentType, true), attribute);
        }
    }

    protected String getEntryIdentifier(AttributedType attributedType) {
        try {
            List<SearchResult> search = this.operationManager.search(this.getBaseDN(attributedType), "(" + this.getBindingDN(attributedType, false) + ")", this.getMappingConfig(attributedType.getClass()));
            javax.naming.directory.Attribute id = search.get(0).getAttributes().get(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName());
            if (id == null) {
                throw new IdentityManagementException("Could not retrieve identifier for entry [" + this.getBindingDN(attributedType, true) + "].");
            }
            return this.operationManager.decodeEntryUUID(id.get());
        }
        catch (NamingException ne) {
            throw new IdentityManagementException("Could not add type [" + attributedType + "].", ne);
        }
    }
}

