/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.scope.viewaccess;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.deltaspike.core.api.scope.ViewAccessScoped;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessBeanAccessHistory;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessBeanHolder;
import org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessViewHistory;
import org.apache.deltaspike.core.impl.scope.window.WindowContextImpl;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualInstanceInfo;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class ViewAccessContext
extends AbstractContext {
    private static final String KEY = "VAS";
    private final BeanManager beanManager;
    private final WindowContextImpl windowContext;
    private ViewAccessBeanHolder viewAccessBeanHolder;
    private ViewAccessBeanAccessHistory viewAccessBeanAccessHistory;
    private ViewAccessViewHistory viewAccessViewHistory;

    public ViewAccessContext(BeanManager beanManager, WindowContextImpl windowContext) {
        super(beanManager);
        this.beanManager = beanManager;
        this.windowContext = windowContext;
    }

    public void init(ViewAccessBeanHolder viewAccessBeanHolder, ViewAccessBeanAccessHistory viewAccessBeanAccessHistory, ViewAccessViewHistory viewAccessViewHistory) {
        this.viewAccessBeanHolder = viewAccessBeanHolder;
        this.viewAccessBeanAccessHistory = viewAccessBeanAccessHistory;
        this.viewAccessViewHistory = viewAccessViewHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Contextual<T> bean) {
        try {
            T t = super.get(bean);
            return t;
        }
        finally {
            if (bean instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)bean;
                this.viewAccessBeanAccessHistory.getAccessedBeans().add(pc.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        try {
            T t = super.get(bean, creationalContext);
            return t;
        }
        finally {
            if (bean instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)bean;
                this.viewAccessBeanAccessHistory.getAccessedBeans().add(pc.getId());
            }
        }
    }

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        return this.viewAccessBeanHolder.getContextualStorage(this.beanManager, KEY, createIfNotExist);
    }

    public Class<? extends Annotation> getScope() {
        return ViewAccessScoped.class;
    }

    public boolean isActive() {
        return this.windowContext.isActive();
    }

    public void onProcessingViewFinished(String view) {
        if (!this.windowContext.isActive()) {
            return;
        }
        if (!view.equals(this.viewAccessViewHistory.getLastView())) {
            this.viewAccessViewHistory.setLastView(view);
            this.destroyExpiredBeans();
        }
        this.viewAccessBeanAccessHistory.getAccessedBeans().clear();
    }

    private void destroyExpiredBeans() {
        ContextualStorage storage = this.viewAccessBeanHolder.getContextualStorage(this.beanManager, KEY, false);
        if (storage != null) {
            for (Map.Entry<Object, ContextualInstanceInfo<?>> storageEntry : storage.getStorage().entrySet()) {
                if (this.viewAccessBeanAccessHistory.getAccessedBeans().contains((String)storageEntry.getKey())) continue;
                Contextual<?> bean = storage.getBean(storageEntry.getKey());
                AbstractContext.destroyBean(bean, storageEntry.getValue());
                storage.getStorage().remove(storageEntry.getKey());
            }
        }
    }
}

