/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.apache.deltaspike.security.api.authorization.Secures;
import org.apache.deltaspike.security.api.authorization.SecurityDefinitionException;
import org.apache.deltaspike.security.impl.extension.AuthorizationParameter;
import org.apache.deltaspike.security.impl.extension.Authorizer;
import org.apache.deltaspike.security.impl.extension.SecurityInterceptorBinding;
import org.apache.deltaspike.security.impl.extension.SecurityInterceptorBindingLiteral;
import org.apache.deltaspike.security.impl.extension.SecurityMetaDataStorage;
import org.apache.deltaspike.security.impl.util.SecurityUtils;

public class SecurityExtension
implements Extension,
Deactivatable {
    private static final SecurityInterceptorBinding INTERCEPTOR_BINDING = new SecurityInterceptorBindingLiteral();
    private SecurityMetaDataStorage securityMetaDataStorage;
    private Boolean isActivated = null;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        this.securityMetaDataStorage = new SecurityMetaDataStorage();
    }

    public SecurityMetaDataStorage getMetaDataStorage() {
        return this.securityMetaDataStorage;
    }

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        AnnotatedTypeBuilder builder = null;
        AnnotatedType type = event.getAnnotatedType();
        boolean isSecured = false;
        for (Annotation annotation : type.getAnnotations()) {
            if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
            builder = new AnnotatedTypeBuilder().readFromType(type);
            builder.addToClass(INTERCEPTOR_BINDING);
            this.getMetaDataStorage().addSecuredType(type);
            isSecured = true;
            break;
        }
        if (!isSecured) {
            block1: for (AnnotatedMethod m : type.getMethods()) {
                if (m.isAnnotationPresent(Secures.class)) {
                    this.registerAuthorizer(m);
                    continue;
                }
                for (Annotation annotation : m.getAnnotations()) {
                    if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
                    if (builder == null) {
                        builder = new AnnotatedTypeBuilder().readFromType(type);
                    }
                    builder.addToMethod(m, (Annotation)INTERCEPTOR_BINDING);
                    this.getMetaDataStorage().addSecuredMethod(m);
                    continue block1;
                }
            }
        }
        if (builder != null) {
            event.setAnnotatedType(builder.create());
        }
    }

    public void validateBindings(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        SecurityMetaDataStorage metaDataStorage = this.getMetaDataStorage();
        metaDataStorage.registerSecuredMethods();
        block0: for (AnnotatedMethod<?> method : metaDataStorage.getSecuredMethods()) {
            Class targetClass = method.getDeclaringType().getJavaClass();
            Method targetMethod = method.getJavaMember();
            for (Annotation annotation : SecurityUtils.getSecurityBindingTypes(targetClass, targetMethod)) {
                boolean found = false;
                HashSet<AuthorizationParameter> authorizationParameters = new HashSet<AuthorizationParameter>();
                for (AnnotatedParameter parameter : method.getParameters()) {
                    HashSet<Annotation> securityParameterBindings = null;
                    for (Annotation a : parameter.getAnnotations()) {
                        if (!SecurityUtils.isMetaAnnotatedWithSecurityParameterBinding(a)) continue;
                        if (securityParameterBindings == null) {
                            securityParameterBindings = new HashSet<Annotation>();
                        }
                        securityParameterBindings.add(a);
                    }
                    if (securityParameterBindings == null) continue;
                    AuthorizationParameter authorizationParameter = new AuthorizationParameter(parameter.getBaseType(), securityParameterBindings);
                    authorizationParameters.add(authorizationParameter);
                }
                for (Authorizer auth : metaDataStorage.getAuthorizers()) {
                    if (!auth.matchesBindings(annotation, authorizationParameters, targetMethod.getReturnType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                event.addDefinitionError((Throwable)new SecurityDefinitionException("Secured type " + method.getDeclaringType().getJavaClass().getName() + " has no matching authorizer method for security binding @" + annotation.annotationType().getName()));
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
                metaDataStorage.registerSecuredMethod(targetClass, targetMethod);
                continue block0;
            }
        }
        metaDataStorage.resetSecuredMethods();
    }

    private void registerAuthorizer(AnnotatedMethod<?> annotatedMethod) {
        if (!annotatedMethod.getJavaMember().getReturnType().equals(Boolean.class) && !annotatedMethod.getJavaMember().getReturnType().equals(Boolean.TYPE)) {
            throw new SecurityDefinitionException("Invalid authorizer method [" + annotatedMethod.getJavaMember().getDeclaringClass().getName() + "." + annotatedMethod.getJavaMember().getName() + "] - does not return a boolean.");
        }
        Annotation binding = null;
        for (Annotation annotation : annotatedMethod.getAnnotations()) {
            if (!SecurityUtils.isMetaAnnotatedWithSecurityBindingType(annotation)) continue;
            if (binding != null) {
                throw new SecurityDefinitionException("Invalid authorizer method [" + annotatedMethod.getJavaMember().getDeclaringClass().getName() + "." + annotatedMethod.getJavaMember().getName() + "] - declares multiple security binding types");
            }
            binding = annotation;
        }
        Authorizer authorizer = new Authorizer(binding, annotatedMethod);
        this.getMetaDataStorage().addAuthorizer(authorizer);
    }
}

