/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.config.http.FilteringMode;
import org.picketlink.config.http.HttpSecurityConfigurationException;
import org.picketlink.config.http.PathConfiguration;

public class HttpSecurityConfiguration
implements Serializable {
    private static final long serialVersionUID = 4977840664931482301L;
    private final Map<String, List<PathConfiguration>> uriConfiguration = new LinkedHashMap<String, List<PathConfiguration>>();
    private final Map<String, PathConfiguration> groupConfiguration = new LinkedHashMap<String, PathConfiguration>();
    private final FilteringMode filteringMode;

    public HttpSecurityConfiguration(List<PathConfiguration> uriConfigs, FilteringMode filteringMode) {
        for (PathConfiguration configuration : uriConfigs) {
            configuration.setSecurityConfiguration(this);
            if (configuration.isGroup()) {
                String groupName = configuration.getGroupName();
                if (this.groupConfiguration.containsKey(groupName)) {
                    throw new HttpSecurityConfigurationException("Duplicated Group[" + groupName + "] configuration.");
                }
                this.groupConfiguration.put(groupName, configuration);
                continue;
            }
            String uri = configuration.getUri();
            List<PathConfiguration> configurations = this.uriConfiguration.get(uri);
            if (configurations == null) {
                configurations = new ArrayList<PathConfiguration>();
                this.uriConfiguration.put(uri, configurations);
            }
            configurations.add(configuration);
        }
        this.validate();
        if (filteringMode == null) {
            filteringMode = FilteringMode.PERMISSIVE;
        }
        this.filteringMode = filteringMode;
    }

    public Map<String, List<PathConfiguration>> getPaths() {
        return Collections.unmodifiableMap(this.uriConfiguration);
    }

    public Map<String, PathConfiguration> getGroups() {
        return Collections.unmodifiableMap(this.groupConfiguration);
    }

    private void validate() {
        if (this.uriConfiguration.isEmpty()) {
            throw new HttpSecurityConfigurationException("No URI configuration is defined. You must provide at least one URI to protect.");
        }
        for (List<PathConfiguration> configurations : this.uriConfiguration.values()) {
            for (PathConfiguration configuration : configurations) {
                String groupName;
                if (!(configuration.isGroup() || this.groupConfiguration.containsKey(groupName = configuration.getGroupName()) || configuration.isDefaultGroup())) {
                    throw new HttpSecurityConfigurationException("Group [" + groupName + "] for URI [" + configuration.getUri() + "] is not defined.");
                }
                if (!configuration.isSecured() || configuration != null && (configuration == null || configuration.getAuthenticationConfiguration() != null || configuration != null || configuration.getAuthorizationConfiguration() != null || configuration != null || configuration.getLogoutConfiguration() != null || (configuration != null || configuration.getMethods() != null) && !configuration.getMethods().isEmpty() || !configuration.getRedirects().isEmpty())) continue;
                throw new HttpSecurityConfigurationException("You must provide an authentication, authorization or logout configuration for URI [" + configuration.getUri() + "].");
            }
        }
    }

    public boolean isPermissive() {
        return FilteringMode.PERMISSIVE.equals((Object)this.filteringMode);
    }
}

