/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.config.http.InboundHeaderConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.http.HttpMethod;
import org.picketlink.internal.el.ELProcessor;

public class PathMatcher {
    private static final String ANY_RESOURCE_PATTERN = "/*";
    private final Map<String, List<PathConfiguration>> uriConfiguration;
    private final ELProcessor elProcessor;

    public PathMatcher(Map<String, List<PathConfiguration>> uriConfiguration, ELProcessor elProcessor) {
        this.uriConfiguration = uriConfiguration;
        this.elProcessor = elProcessor;
    }

    public PathConfiguration matches(HttpServletRequest request) {
        String requestedUri = request.getRequestURI();
        int contextPathIndex = requestedUri.indexOf(request.getContextPath());
        if (contextPathIndex != -1) {
            requestedUri = requestedUri.substring(contextPathIndex + request.getContextPath().length());
        }
        List<PathConfiguration> configurations = null;
        String actualConfig = null;
        for (Map.Entry<String, List<PathConfiguration>> entry : this.uriConfiguration.entrySet()) {
            String prefix;
            int startRegex;
            String protectedSuffix;
            int suffixIndex;
            String protectedUri = entry.getKey();
            String selectedUri = null;
            if (protectedUri.equals(ANY_RESOURCE_PATTERN) && actualConfig == null) {
                configurations = this.uriConfiguration.get(entry.getKey());
                selectedUri = protectedUri;
            }
            if ((suffixIndex = protectedUri.indexOf("/*.")) != -1 && requestedUri.endsWith(protectedSuffix = protectedUri.substring(suffixIndex + ANY_RESOURCE_PATTERN.length()))) {
                configurations = this.uriConfiguration.get(entry.getKey());
                selectedUri = protectedUri;
            }
            if (protectedUri.equals(requestedUri)) {
                configurations = this.uriConfiguration.get(entry.getKey());
                selectedUri = protectedUri;
            }
            if (protectedUri.endsWith(ANY_RESOURCE_PATTERN)) {
                String formattedPattern = this.removeWildCardsFromUri(protectedUri);
                if (!formattedPattern.equals("/") && requestedUri.startsWith(formattedPattern)) {
                    configurations = this.uriConfiguration.get(entry.getKey());
                    selectedUri = protectedUri;
                }
                if (!formattedPattern.equals("/") && formattedPattern.endsWith("/") && formattedPattern.substring(0, formattedPattern.length() - 1).equals(requestedUri)) {
                    configurations = this.uriConfiguration.get(entry.getKey());
                    selectedUri = protectedUri;
                }
            }
            if ((startRegex = protectedUri.indexOf(123)) != -1 && requestedUri.startsWith(prefix = protectedUri.substring(0, startRegex))) {
                configurations = this.uriConfiguration.get(entry.getKey());
                selectedUri = protectedUri;
            }
            if (selectedUri != null) {
                configurations = this.uriConfiguration.get(entry.getKey());
                selectedUri = protectedUri;
            }
            if (selectedUri == null) continue;
            if (actualConfig == null) {
                actualConfig = entry.getKey();
                continue;
            }
            if (actualConfig.equals(ANY_RESOURCE_PATTERN)) {
                actualConfig = entry.getKey();
            }
            if (!protectedUri.startsWith(this.removeWildCardsFromUri(actualConfig))) continue;
            actualConfig = entry.getKey();
        }
        if (configurations != null) {
            if (configurations.size() == 1) {
                return (PathConfiguration)configurations.get(0);
            }
            int configIndex = -1;
            int lastMatchCount = 0;
            for (int i = 0; i < configurations.size(); ++i) {
                String inboundHeaderName;
                Enumeration requestHeaderValues;
                PathConfiguration pathConfiguration = (PathConfiguration)configurations.get(i);
                InboundHeaderConfiguration headerConfiguration = pathConfiguration.getInboundHeaderConfiguration();
                Set<HttpMethod> methods = pathConfiguration.getMethods();
                if (!methods.contains((Object)HttpMethod.valueOf(request.getMethod().toUpperCase()))) continue;
                if (headerConfiguration == null) {
                    if (configIndex != -1) continue;
                    configIndex = i;
                    continue;
                }
                Map<String, String[]> inboundHeaders = headerConfiguration.getHeaders();
                if (inboundHeaders.isEmpty()) {
                    configIndex = i;
                    continue;
                }
                Iterator<String> iterator = inboundHeaders.keySet().iterator();
                while (iterator.hasNext() && (requestHeaderValues = request.getHeaders(inboundHeaderName = iterator.next())) != null) {
                    List<Object> inboundHeaderValues = Arrays.asList((Object[])inboundHeaders.get(inboundHeaderName));
                    int matchCount = 0;
                    while (requestHeaderValues.hasMoreElements()) {
                        String requestHeaderValue = (String)requestHeaderValues.nextElement();
                        if (!inboundHeaderValues.contains(requestHeaderValue)) continue;
                        ++matchCount;
                    }
                    if (matchCount <= lastMatchCount) continue;
                    lastMatchCount = matchCount;
                    configIndex = i;
                }
            }
            if (configIndex >= 0) {
                return (PathConfiguration)configurations.get(configIndex);
            }
        }
        return null;
    }

    private String removeWildCardsFromUri(String protectedUri) {
        return protectedUri.replaceAll("/[*]", "/");
    }
}

