/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import java.util.EnumSet;
import javax.inject.Inject;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.picketlink.config.SecurityConfiguration;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.http.internal.SecurityFilter;
import org.picketlink.log.BaseLog;

@WebListener
public class PicketLinkServletContextListener
implements ServletContextListener {
    public static final String PICKETLINK_SECURITY_FILTER_NAME = "PicketLink Security Filter";
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    private SecurityFilter securityFilter;

    public void contextInitialized(ServletContextEvent sce) {
        if (this.isHttpSecurityEnabled()) {
            BaseLog.HTTP_LOGGER.info("Initializing PicketLink HTTP Security");
            this.addSecurityFilter(sce);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private void addSecurityFilter(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        FilterRegistration.Dynamic filter = servletContext.addFilter(PICKETLINK_SECURITY_FILTER_NAME, (Filter)this.securityFilter);
        if (filter != null) {
            filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        } else {
            BaseLog.HTTP_LOGGER.warn("PicketLink Security Filter already registered. You have probably defined the filter in your web deployment descriptor.");
        }
    }

    private boolean isHttpSecurityEnabled() {
        SecurityConfiguration securityConfiguration = this.picketLinkExtension.getSecurityConfiguration();
        return securityConfiguration.getHttpSecurityConfiguration() != null;
    }
}

