/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.picketlink.common.util.Base64;
import org.picketlink.http.internal.authentication.schemes.support.UUIDNonceGenerator;
import org.picketlink.idm.credential.Digest;

public class NonceCache
extends TimerTask {
    private UUIDNonceGenerator nonceGenerator = new UUIDNonceGenerator();
    private long nonceMaxValid = 180000L;
    private Map<String, List<String>> nonceCache = new HashMap<String, List<String>>();

    @Override
    public void run() {
        if (this.nonceCache.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, List<String>>> cacheEntries = new HashMap<String, List<String>>(this.nonceCache).entrySet();
        for (Map.Entry<String, List<String>> entry : cacheEntries) {
            List<String> nonces = entry.getValue();
            for (String nonce : new ArrayList<String>(nonces)) {
                if (!this.hasExpired(nonce, this.nonceMaxValid)) continue;
                nonces.remove(nonce);
            }
            if (!nonces.isEmpty()) continue;
            this.nonceCache.remove(entry.getKey());
        }
    }

    public String generateAndCacheNonce(HttpServletRequest request) {
        String newNonce = this.nonceGenerator.get();
        HttpSession session = request.getSession();
        List<String> storedNonces = this.nonceCache.get(session.getId());
        if (storedNonces == null) {
            storedNonces = new ArrayList<String>();
            this.nonceCache.put(session.getId(), storedNonces);
        }
        storedNonces.add(newNonce);
        return newNonce;
    }

    public boolean hasValidNonce(Digest digest, HttpServletRequest request) {
        String nonce = digest.getNonce();
        List<String> storedNonces = this.nonceCache.get(request.getSession().getId());
        return storedNonces != null && storedNonces.contains(nonce) && !this.hasExpired(nonce, this.nonceMaxValid);
    }

    public boolean hasExpired(String nonceValue, long maxValue) {
        int colonIndex = (nonceValue = new String(Base64.decode(nonceValue))).indexOf(":");
        if (colonIndex < 0) {
            return true;
        }
        String timeValue = nonceValue.substring(0, colonIndex);
        long parsedTimeValue = Long.parseLong(timeValue);
        long ms = System.currentTimeMillis() - parsedTimeValue;
        return ms > maxValue;
    }

    public long getNonceMaxValid() {
        return this.nonceMaxValid;
    }
}

