/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.picketlink.common.logging.Log;
import org.picketlink.common.logging.LogFactory;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.spi.IdentityStore;

@MessageLogger(projectCode="PLIDM")
public interface IDMLog
extends Log {
    public static final String PICKETLINK_IDM_PROJECT_CODE = "PLIDM";
    public static final IDMLog ROOT_LOGGER = LogFactory.getLog(IDMLog.class, IDMLog.class.getPackage().getName());
    public static final IDMLog IDENTITY_STORE_LOGGER = LogFactory.getLog(IDMLog.class, IDMLog.class.getPackage().getName() + ".identity.store");
    public static final IDMLog CREDENTIAL_LOGGER = LogFactory.getLog(IDMLog.class, IDMLog.class.getPackage().getName() + ".credential");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1000, value="Bootstrapping PicketLink IDM Partition Manager")
    public void partitionManagerBootstrap();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1001, value="Initializing Identity Store [%s]")
    public void storeInitializing(Class<? extends IdentityStore> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1002, value="No partition assigned for identity type [%s] by identity store [%s]. We assume this entry belongs to the default partition [%s].")
    public void partitionUndefinedForTypeUsingDefault(IdentityType var1, IdentityStore var2, Partition var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1003, value="Trying to find account [%s] using default account type [%s] with property [%s].")
    public void credentialRetrievingAccount(String var1, Class<? extends Account> var2, String var3);
}

