/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.TokenCredential;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.TokenCredentialStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={TokenCredential.class, Token.class}, credentialStorage=TokenCredentialStorage.class)
public class TokenCredentialHandler<S extends CredentialStore<?>, V extends TokenCredential, U extends Token>
extends AbstractCredentialHandler<S, V, U> {
    public static final String TOKEN_CONSUMER = "TOKEN_CONSUMER";
    private final List<Token.Consumer> tokenConsumers = new ArrayList<Token.Consumer>();

    @Override
    public void setup(S store) {
        super.setup(store);
        Object configuredTokenConsumers = store.getConfig().getCredentialHandlerProperties().get(TOKEN_CONSUMER);
        if (configuredTokenConsumers != null) {
            try {
                if (Token.Consumer.class.isInstance(configuredTokenConsumers)) {
                    this.tokenConsumers.add((Token.Consumer)configuredTokenConsumers);
                } else if (configuredTokenConsumers.getClass().isArray()) {
                    this.tokenConsumers.addAll(Arrays.asList((Token.Consumer[])configuredTokenConsumers));
                } else if (List.class.isInstance(configuredTokenConsumers)) {
                    this.tokenConsumers.addAll((List)configuredTokenConsumers);
                }
            }
            catch (ClassCastException cce) {
                throw new SecurityConfigurationException("Token consumer is not a " + Token.Consumer.class.getName() + " instance. You provided " + configuredTokenConsumers);
            }
        }
    }

    @Override
    protected boolean validateCredential(IdentityContext context, CredentialStorage credentialStorage, V credentials, S store) {
        TokenCredentialStorage tokenCredentialStorage;
        Token token = ((TokenCredential)credentials).getToken();
        if (this.getTokenConsumer(token) != null) {
            return this.getTokenConsumer(token).validate(token);
        }
        return credentialStorage != null && (tokenCredentialStorage = (TokenCredentialStorage)credentialStorage).getToken().equals(token.getToken()) && tokenCredentialStorage.getType().equals(token.getType());
    }

    @Override
    protected Account getAccount(IdentityContext context, V credentials) {
        Token token = ((TokenCredential)credentials).getToken();
        if (token != null) {
            String subject = token.getSubject();
            if (subject == null) {
                throw new IdentityManagementException("No subject returned from token [" + token + "].");
            }
            Account account = this.getAccount(context, (V)subject);
            if (account == null) {
                account = this.getAccountById(context, subject);
            }
            return account;
        }
        return null;
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, V credentials, S store) {
        return store.retrieveCurrentCredential(context, account, this.getCredentialStorageType());
    }

    @Override
    public CredentialStorage createCredentialStorage(IdentityContext context, Account account, U credential, S store, Date effectiveDate, Date expiryDate) {
        TokenCredentialStorage tokenStorage = this.createCredentialStorageInstance();
        tokenStorage.setType(credential.getType());
        tokenStorage.setToken(credential.getToken());
        if (effectiveDate != null) {
            tokenStorage.setEffectiveDate(effectiveDate);
        }
        if (tokenStorage.getExpiryDate() == null) {
            tokenStorage.setExpiryDate(expiryDate);
        }
        if (tokenStorage.getType() == null) {
            throw new IdentityManagementException("TokenCredentialStorage can not have a null type.");
        }
        return tokenStorage;
    }

    protected Class<? extends TokenCredentialStorage> getCredentialStorageType() {
        SupportsCredentials supportsCredentials = this.getClass().getAnnotation(SupportsCredentials.class);
        Class<? extends CredentialStorage> credentialStorage = supportsCredentials.credentialStorage();
        try {
            return credentialStorage;
        }
        catch (ClassCastException cce) {
            throw new IdentityManagementException("CredentialStorage [" + credentialStorage + "] is not a " + TokenCredentialStorage.class + " type.", cce);
        }
    }

    protected TokenCredentialStorage createCredentialStorageInstance() {
        try {
            return Reflections.newInstance(this.getCredentialStorageType());
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not create TokenStorageCredential [" + this.getCredentialStorageType() + "].", e);
        }
    }

    private <T extends Token> Token.Consumer<T> getTokenConsumer(T token) {
        for (Token.Consumer selectedConsumer : this.tokenConsumers) {
            if (!selectedConsumer.getTokenType().isAssignableFrom(token.getClass())) continue;
            return selectedConsumer;
        }
        return null;
    }
}

