/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.annotations.Stored;
import org.picketlink.idm.file.internal.AbstractFileType;

public class FileCredentialStorage
extends AbstractFileType<CredentialStorage> {
    private static final String VERSION = "1";

    protected FileCredentialStorage(CredentialStorage object) {
        super(VERSION, object);
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        for (Property<Serializable> property : this.getStoredProperties()) {
            Serializable value = property.getValue(this.getEntry());
            if (value == null) continue;
            properties.put(property.getName(), value);
        }
    }

    @Override
    protected CredentialStorage doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        CredentialStorage credentialStorage = (CredentialStorage)Class.forName(this.getType()).newInstance();
        for (Property<Serializable> property : this.getStoredProperties()) {
            property.setValue(credentialStorage, properties.get(property.getName()));
        }
        return credentialStorage;
    }

    private List<Property<Serializable>> getStoredProperties() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CredentialStorage credentialStorage = (CredentialStorage)Class.forName(this.getType()).newInstance();
        PropertyQuery query = PropertyQueries.createQuery(credentialStorage.getClass());
        query.addCriteria(new AnnotatedPropertyCriteria(Stored.class));
        return query.getResultList();
    }
}

