/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.picketlink.idm.DefaultIdGenerator;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultStoreSelector;
import org.picketlink.idm.internal.PrivilegeChainQuery;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.permission.acl.spi.PermissionHandlerPolicy;

class PartitionManagerConfiguration {
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private final Collection<IdentityConfiguration> configurations;
    private final IdentityConfiguration partitionManagementConfig;
    private final IdentityConfiguration attributeManagementConfig;
    private final EventBridge eventBridge;
    private final IdGenerator idGenerator;
    private final DefaultStoreSelector storeSelector;
    private PrivilegeChainQuery privilegeChainQuery = new PrivilegeChainQuery();
    private PermissionHandlerPolicy permissionHandlerPolicy;

    public PartitionManagerConfiguration(Collection<IdentityConfiguration> configurations, Collection<PermissionHandler> permissionHandlers, EventBridge eventBridge, IdGenerator idGenerator) {
        IDMLog.ROOT_LOGGER.partitionManagerBootstrap();
        if (configurations == null || configurations.isEmpty()) {
            throw IDMInternalMessages.MESSAGES.configNoIdentityConfigurationProvided();
        }
        this.configurations = Collections.unmodifiableCollection(configurations);
        IdentityConfiguration partitionCfg = null;
        IdentityConfiguration attributeCfg = null;
        for (IdentityConfiguration config : configurations) {
            for (IdentityStoreConfiguration identityStoreConfiguration : config.getStoreConfiguration()) {
                if (identityStoreConfiguration.supportsPartition()) {
                    partitionCfg = config;
                }
                if (!identityStoreConfiguration.supportsAttribute()) continue;
                attributeCfg = config;
            }
        }
        this.partitionManagementConfig = partitionCfg;
        this.attributeManagementConfig = attributeCfg;
        this.permissionHandlerPolicy = new PermissionHandlerPolicy(null);
        if (permissionHandlers != null) {
            for (PermissionHandler handler : permissionHandlers) {
                this.permissionHandlerPolicy.registerHandler(handler);
            }
        }
        for (IdentityConfiguration config : configurations) {
            for (IdentityStoreConfiguration identityStoreConfiguration : config.getStoreConfiguration()) {
                for (Class<? extends AttributedType> supportedType : identityStoreConfiguration.getSupportedTypes().keySet()) {
                    if (!Relationship.class.isAssignableFrom(supportedType)) continue;
                    this.privilegeChainQuery.registerRelationshipType(supportedType);
                }
            }
        }
        this.eventBridge = eventBridge == null ? new EventBridge(){

            @Override
            public void raiseEvent(Object event) {
            }
        } : eventBridge;
        this.idGenerator = idGenerator == null ? new DefaultIdGenerator() : idGenerator;
        this.logConfiguration(this.configurations);
        this.storeSelector = new DefaultStoreSelector(this);
    }

    private void logConfiguration(Collection<IdentityConfiguration> configurations) {
        for (IdentityConfiguration identityConfiguration : configurations) {
            if (!IDMLog.ROOT_LOGGER.isDebugEnabled()) continue;
            IDMLog.ROOT_LOGGER.debug("  Identity Management Configuration: [");
            IDMLog.ROOT_LOGGER.debugf("    Name: %s", identityConfiguration.getName());
            IDMLog.ROOT_LOGGER.debugf("    Identity Store Configuration: %s", identityConfiguration.getStoreConfiguration());
            IDMLog.ROOT_LOGGER.debugf("    Supports Partition: %s", this.partitionManagementConfig != null && this.partitionManagementConfig.equals(identityConfiguration));
            IDMLog.ROOT_LOGGER.debugf("    Supports Attribute: %s", this.attributeManagementConfig != null && this.attributeManagementConfig.equals(identityConfiguration));
            IDMLog.ROOT_LOGGER.debugf("    Supports Credential: %s", identityConfiguration.supportsCredential());
            IDMLog.ROOT_LOGGER.debugf("    Supports Permission: %s", identityConfiguration.supportsPermission());
            ArrayList<Class<? extends AttributedType>> supportedTypes = new ArrayList<Class<? extends AttributedType>>();
            for (IdentityStoreConfiguration identityStoreConfiguration : identityConfiguration.getStoreConfiguration()) {
                supportedTypes.addAll(identityStoreConfiguration.getSupportedTypes().keySet());
            }
            IDMLog.ROOT_LOGGER.debugf("    Supported Types: %s", supportedTypes);
            IDMLog.ROOT_LOGGER.debug("  ]");
        }
    }

    IdentityConfiguration getConfigurationByName(String name) {
        for (IdentityConfiguration config : this.configurations) {
            if (!name.equals(config.getName())) continue;
            return config;
        }
        throw IDMInternalMessages.MESSAGES.partitionNoConfigurationFound(name);
    }

    String getDefaultConfigurationName() {
        for (IdentityConfiguration config : this.configurations) {
            if (!DEFAULT_CONFIGURATION_NAME.equals(config.getName())) continue;
            return DEFAULT_CONFIGURATION_NAME;
        }
        return this.configurations.iterator().next().getName();
    }

    boolean supportsPartition() {
        return this.partitionManagementConfig != null;
    }

    Collection<IdentityConfiguration> getConfigurations() {
        return this.configurations;
    }

    public IdentityConfiguration getPartitionManagementConfig() {
        return this.partitionManagementConfig;
    }

    public IdentityConfiguration getAttributeManagementConfig() {
        return this.attributeManagementConfig;
    }

    public PermissionHandlerPolicy getPermissionHandlerPolicy() {
        return this.permissionHandlerPolicy;
    }

    public PrivilegeChainQuery getPrivilegeChainQuery() {
        return this.privilegeChainQuery;
    }

    public EventBridge getEventBridge() {
        return this.eventBridge;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public DefaultStoreSelector getStoreSelector() {
        return this.storeSelector;
    }
}

