/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.JDBCIdentityStoreConfiguration;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.jdbc.internal.mappers.JdbcMapper;
import org.picketlink.idm.jdbc.internal.model.AbstractJdbcType;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.jdbc.internal.model.RelationshipJdbcType;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.PartitionStore;

public class JDBCIdentityStore
extends AbstractIdentityStore<JDBCIdentityStoreConfiguration>
implements CredentialStore<JDBCIdentityStoreConfiguration>,
PartitionStore<JDBCIdentityStoreConfiguration>,
AttributeStore<JDBCIdentityStoreConfiguration> {
    private DataSource dataSource = null;
    private JdbcMapper mapper = new JdbcMapper();

    @Override
    public void setup(JDBCIdentityStoreConfiguration config) {
        super.setup(config);
        this.dataSource = config.getDataSource();
        Map<String, Class<?>> customClassMapping = config.getCustomClassMapping();
        if (customClassMapping != null) {
            Set<String> keyset = customClassMapping.keySet();
            for (String key : keyset) {
                JdbcMapper.map(key, customClassMapping.get(key));
            }
        }
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
        Object att = this.mapper.getInstance(identityType.getClass());
        ((AbstractJdbcType)att).setDataSource(this.dataSource);
        ((AbstractJdbcType)att).deleteRelationships(identityType);
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
    }

    @Override
    protected void addAttributedType(IdentityContext context, AttributedType attributedType) {
        Object att = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)att).setDataSource(this.dataSource).persist(attributedType);
    }

    @Override
    protected void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        Object ajt = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
        ((AbstractJdbcType)ajt).update(attributedType);
    }

    @Override
    protected void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        Object ajt = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
        ((AbstractJdbcType)ajt).delete(attributedType);
    }

    @Override
    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public void removeCredential(IdentityContext context, Account account, Class<? extends CredentialStorage> storageClass) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        ArrayList<? extends AttributedType> result = new ArrayList<AttributedType>();
        AttributedType attributedType = null;
        if (identityQuery.getParameter(IdentityType.ID) != null) {
            Object[] parameter = identityQuery.getParameter(IdentityType.ID);
            if (parameter.length <= 0) throw new RuntimeException();
            Object id = parameter[0];
            Object ajt = this.mapper.getInstance(identityQuery.getIdentityType());
            ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
            attributedType = ((AbstractJdbcType)ajt).load((String)id, identityQuery.getIdentityType());
            if (attributedType == null) return result;
            result.add((IdentityType)attributedType);
            return result;
        } else {
            Object ajt = this.mapper.getInstance(identityQuery.getIdentityType());
            ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
            List<? extends AttributedType> list = ((AbstractJdbcType)ajt).load(identityQuery.getParameters(), identityQuery.getIdentityType());
            if (list.isEmpty()) return result;
            result.addAll(list);
        }
        return result;
    }

    @Override
    public <V extends IdentityType> int countQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        RelationshipJdbcType relationshipJdbcType = new RelationshipJdbcType();
        relationshipJdbcType.setDataSource(this.dataSource);
        ArrayList<? extends AttributedType> result = new ArrayList<AttributedType>();
        List<? extends AttributedType> list = relationshipJdbcType.load(query.getParameters(), query.getRelationshipClass());
        if (!list.isEmpty()) {
            result.addAll(list);
        }
        return result;
    }

    @Override
    public <V extends Relationship> int countQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public void setAttribute(IdentityContext context, AttributedType attributedType, Attribute<? extends Serializable> attribute) {
        Object ajt = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)ajt).setId(attributedType.getId());
        ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
        ((AbstractJdbcType)ajt).setType(attributedType);
        ajt.setAttribute(attribute);
    }

    @Override
    public <V extends Serializable> Attribute<V> getAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        Object ajt = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)ajt).setId(attributedType.getId());
        ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
        ((AbstractJdbcType)ajt).setType(attributedType);
        return ajt.getAttribute(attributeName);
    }

    @Override
    public void removeAttribute(IdentityContext context, AttributedType attributedType, String attributeName) {
        Object ajt = this.mapper.getInstance(attributedType.getClass());
        ((AbstractJdbcType)ajt).setId(attributedType.getId());
        ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
        ((AbstractJdbcType)ajt).setType(attributedType);
        ajt.removeAttribute(attributeName);
    }

    @Override
    public void loadAttributes(IdentityContext context, AttributedType attributedType) {
        if (attributedType != null) {
            Object ajt = this.mapper.getInstance(attributedType.getClass());
            ((AbstractJdbcType)ajt).setDataSource(this.dataSource);
            ((AbstractJdbcType)ajt).setId(attributedType.getId());
            Collection<Attribute<? extends Serializable>> attributes = ajt.getAttributes();
            if (attributes != null) {
                for (Attribute<? extends Serializable> attribute : attributes) {
                    attributedType.setAttribute(attribute);
                }
            }
        }
    }

    @Override
    public String getConfigurationName(IdentityContext identityContext, Partition partition) {
        return "SIMPLE_JDBC_STORE_CONFIG";
    }

    @Override
    public <P extends Partition> P get(IdentityContext identityContext, Class<P> partitionClass, String name) {
        PartitionJdbcType pjt = new PartitionJdbcType(name);
        pjt.setDataSource(this.dataSource);
        HashMap<QueryParameter, Object[]> map = new HashMap<QueryParameter, Object[]>();
        map.put(new AttributeParameter("name"), new Object[]{name});
        return (P)((Partition)pjt.load(map, Partition.class).get(0));
    }

    @Override
    public <P extends Partition> List<P> get(IdentityContext identityContext, Class<P> partitionClass) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public <P extends Partition> P lookupById(IdentityContext context, Class<P> partitionClass, String id) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public void add(IdentityContext identityContext, Partition partition, String configurationName) {
        PartitionJdbcType partitionJdbcType = new PartitionJdbcType(partition.getName());
        partitionJdbcType.setDataSource(this.dataSource);
        if (partition.getId() == null) {
            if (partition instanceof Realm) {
                partitionJdbcType.setId("default");
            } else {
                partitionJdbcType.setId(identityContext.getIdGenerator().generate());
            }
        }
        partitionJdbcType.setConfigurationName(configurationName).setTypeName(partition.getClass().getName());
        partitionJdbcType.persist(partitionJdbcType);
    }

    @Override
    public void update(IdentityContext identityContext, Partition partition) {
        throw IDMMessages.MESSAGES.notImplemented();
    }

    @Override
    public void remove(IdentityContext identityContext, Partition partition) {
        throw IDMMessages.MESSAGES.notImplemented();
    }
}

