/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.jpa.annotations.IdentityClass;
import org.picketlink.idm.jpa.annotations.entity.IdentityManaged;
import org.picketlink.idm.jpa.internal.mappers.AbstractAttributedTypeMapper;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;

public class IdentityTypeMapper
extends AbstractAttributedTypeMapper {
    @Override
    public boolean supports(Class<?> entityType) {
        Property result;
        if (entityType.isAnnotationPresent(IdentityManaged.class) && (result = PropertyQueries.createQuery(entityType).addCriteria(new AnnotatedPropertyCriteria(IdentityClass.class)).getFirstResult()) != null) {
            if (!result.getJavaClass().equals(String.class)) {
                throw new SecurityConfigurationException("IdentityType entities should be mapped with String valued @IdentityClass property.");
            }
            return true;
        }
        return false;
    }

    @Override
    public EntityMapping configure(Class<?> supportedTypes, Class<?> entityType) {
        EntityMapping entityMapping = super.configure(supportedTypes, entityType);
        entityMapping.addTypeProperty(this.getAnnotatedProperty(IdentityClass.class, entityType));
        entityMapping.addOwnerProperty(entityType);
        return entityMapping;
    }
}

