/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.Date;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={UsernamePasswordCredentials.class, Password.class}, credentialStorage=SupportsCredentials.NO_CREDENTIAL_STORAGE.class)
public class LDAPPlainTextPasswordCredentialHandler<S, V, U>
extends AbstractCredentialHandler<LDAPIdentityStore, UsernamePasswordCredentials, Password> {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    @Override
    protected boolean validateCredential(IdentityContext context, CredentialStorage credentialStorage, UsernamePasswordCredentials credentials, LDAPIdentityStore ldapIdentityStore) {
        char[] password;
        String bindingDN;
        Account account = this.getAccount(context, credentials.getUsername());
        LDAPOperationManager operationManager = ldapIdentityStore.getOperationManager();
        return operationManager.authenticate(bindingDN = ldapIdentityStore.getBindingDN(account), new String(password = credentials.getPassword().getValue()));
    }

    @Override
    protected Account getAccount(IdentityContext context, UsernamePasswordCredentials credentials) {
        return this.getAccount(context, credentials.getUsername());
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, UsernamePasswordCredentials credentials, LDAPIdentityStore store) {
        return null;
    }

    @Override
    public void update(IdentityContext context, Account account, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        if (((LDAPIdentityStoreConfiguration)store.getConfig()).isActiveDirectory()) {
            this.updateADPassword(account, new String(password.getValue()), store);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                store.getOperationManager().modifyAttribute(store.getBindingDN(account, true), mod0);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error updating password.", e);
            }
        }
    }

    @Override
    protected CredentialStorage createCredentialStorage(IdentityContext context, Account account, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        throw new RuntimeException("This handler does not store passwords using a credential storage.");
    }

    private void updateADPassword(Account account, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getOperationManager().modifyAttribute(store.getBindingDN(account, true), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

