/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.acl.spi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.permission.acl.spi.BaseAbstractPermissionHandler;

public class EntityPermissionHandler
extends BaseAbstractPermissionHandler {
    private static final String SEPARATOR = ":";
    private Class<? extends Annotation> entityAnnotationClass = null;
    private Class<? extends Annotation> idAnnotationClass = null;
    private Map<Class<?>, List<Property<Serializable>>> idProperties = new ConcurrentHashMap();

    public EntityPermissionHandler() {
        try {
            this.entityAnnotationClass = Reflections.classForName("javax.persistence.Entity", new ClassLoader[0]);
            this.idAnnotationClass = Reflections.classForName("javax.persistence.Id", new ClassLoader[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean canHandle(Class<?> resourceClass) {
        return this.entityAnnotationClass != null && resourceClass.isAnnotationPresent(this.entityAnnotationClass);
    }

    private List<Property<Serializable>> getIdProperties(Object resource) {
        Class<?> resourceClass = this.unwrapResourceClass(resource);
        if (!this.idProperties.containsKey(resourceClass)) {
            this.queryIdProperties(resourceClass);
        }
        return this.idProperties.get(resourceClass);
    }

    private synchronized void queryIdProperties(Class<?> resourceClass) {
        if (!this.idProperties.containsKey(resourceClass)) {
            List props = PropertyQueries.createQuery(resourceClass).addCriteria(new AnnotatedPropertyCriteria(this.idAnnotationClass)).getResultList();
            if (props.size() > 1) {
                Collections.sort(props, new Comparator<Property<Serializable>>(){

                    @Override
                    public int compare(Property<Serializable> a, Property<Serializable> b) {
                        return a.getName().compareTo(b.getName());
                    }
                });
            }
            this.idProperties.put(resourceClass, props);
        }
    }

    @Override
    public Serializable getIdentifier(Object resource) {
        List<Property<Serializable>> props = this.getIdProperties(resource);
        if (props.size() == 1) {
            return props.get(0).getValue(resource);
        }
        if (props.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Property<Serializable> p : props) {
                if (sb.length() > 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(p.getValue(resource).toString());
            }
            return sb.toString();
        }
        throw new IdentityManagementException(String.format("Could not locate @Id property for specified resource [%s]", resource));
    }

    @Override
    public Class<?> unwrapResourceClass(Object resource) {
        return resource.getClass();
    }
}

