/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.Condition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.Sort;
import org.picketlink.idm.query.internal.BetweenCondition;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.EqualCondition;
import org.picketlink.idm.query.internal.GreaterThanCondition;
import org.picketlink.idm.query.internal.InCondition;
import org.picketlink.idm.query.internal.LessThanCondition;
import org.picketlink.idm.query.internal.LikeCondition;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class DefaultQueryBuilder
implements IdentityQueryBuilder {
    private final StoreSelector storeSelector;
    private final IdentityContext identityContext;
    private final PartitionManager partitionManager;

    public DefaultQueryBuilder(IdentityContext identityContext, PartitionManager partitionManager, StoreSelector storeSelector) {
        this.identityContext = identityContext;
        this.partitionManager = partitionManager;
        this.storeSelector = storeSelector;
    }

    @Override
    public Condition like(QueryParameter parameter, String pattern) {
        return new LikeCondition(parameter, pattern);
    }

    @Override
    public Condition equal(QueryParameter parameter, Object value) {
        return new EqualCondition(parameter, value);
    }

    @Override
    public Condition greaterThan(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new GreaterThanCondition(parameter, (Comparable)x, false);
    }

    @Override
    public Condition greaterThanOrEqualTo(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new GreaterThanCondition(parameter, (Comparable)x, true);
    }

    @Override
    public Condition lessThan(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new LessThanCondition(parameter, (Comparable)x, false);
    }

    @Override
    public Condition lessThanOrEqualTo(QueryParameter parameter, Object x) {
        this.throwExceptionIfNotComparable(x);
        return new LessThanCondition(parameter, (Comparable)x, true);
    }

    @Override
    public Condition between(QueryParameter parameter, Object x, Object y) {
        this.throwExceptionIfNotComparable(x);
        this.throwExceptionIfNotComparable(y);
        return new BetweenCondition(parameter, (Comparable)x, (Comparable)y);
    }

    @Override
    public Condition in(QueryParameter parameter, Object ... x) {
        return new InCondition(parameter, x);
    }

    @Override
    public Sort asc(QueryParameter parameter) {
        return new Sort(parameter, true);
    }

    @Override
    public Sort desc(QueryParameter parameter) {
        return new Sort(parameter, false);
    }

    public <T extends IdentityType> IdentityQuery createIdentityQuery(Class<T> identityType) {
        return new DefaultIdentityQuery<T>(this, this.identityContext, identityType, this.partitionManager, this.storeSelector);
    }

    private void throwExceptionIfNotComparable(Object x) {
        if (!Comparable.class.isInstance(x)) {
            throw new IdentityManagementException("Query parameter value [" + x + "] must be " + Comparable.class + ".");
        }
    }
}

