/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal.el;

import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import org.picketlink.Identity;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;

class PicketLinkELResolver
extends ELResolver {
    private final ELResolver target;

    PicketLinkELResolver(ELResolver target) {
        this.target = target;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object value = this.target.getValue(context, base, property);
        if (value == null && base != null) {
            if (Identity.class.isInstance(base)) {
                value = this.resolveInIdentity(context, (Identity)base, property.toString());
            } else if (Account.class.isInstance(base)) {
                value = this.resolveInAccount(context, (Account)base, property.toString());
            } else if (Partition.class.isInstance(base)) {
                value = this.resolveInPartition(context, (Partition)base, property.toString());
            }
        }
        return value;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return this.target.getType(context, base, property);
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        this.target.setValue(context, base, property, value);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return this.target.isReadOnly(context, base, property);
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return this.target.getFeatureDescriptors(context, base);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.target.getCommonPropertyType(context, base);
    }

    private Object resolveInIdentity(ELContext context, Identity identity, String property) {
        Serializable value = null;
        if ("loggedIn".equals(property)) {
            context.setPropertyResolved(true);
            value = identity.isLoggedIn();
        } else if ("account".equals(property)) {
            context.setPropertyResolved(true);
            value = identity.getAccount();
        }
        return value;
    }

    private Object resolveInAccount(ELContext context, Account account, String property) {
        Map<String, Serializable> value = null;
        if ("id".equals(property)) {
            context.setPropertyResolved(true);
            value = account.getId();
        } else if ("partition".equals(property)) {
            context.setPropertyResolved(true);
            value = account.getPartition();
        } else if ("attributes".equals(property)) {
            context.setPropertyResolved(true);
            value = this.getAttributes(account);
        }
        return value;
    }

    private Object resolveInPartition(ELContext context, Partition partition, String property) {
        Object value = null;
        if ("id".equals(property)) {
            context.setPropertyResolved(true);
            value = partition.getId();
        } else if ("name".equals(property)) {
            context.setPropertyResolved(true);
            value = partition.getName();
        } else if ("attributes".equals(property)) {
            context.setPropertyResolved(true);
            value = this.getAttributes(partition);
        }
        return value;
    }

    private Map<String, Serializable> getAttributes(AttributedType attributedType) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        for (Attribute<? extends Serializable> attribute : attributedType.getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        return attributes;
    }
}

