/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.picketlink.config.http.AbstractPathConfigurationChildBuilder;
import org.picketlink.config.http.CORSConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.PathConfigurationBuilder;

public class CORSConfigurationBuilder
extends AbstractPathConfigurationChildBuilder {
    private Set<String> allowedOrigins = new LinkedHashSet<String>();
    private Set<String> allowedMethods = new LinkedHashSet<String>();
    private Set<String> allowedHeaders = new LinkedHashSet<String>();
    private Set<String> exposedHeaders = new LinkedHashSet<String>();
    private boolean allowCredentials;
    private boolean allowAnyOrigin;
    private boolean allowAnyHeader;
    private long maxAge;
    private boolean allowAnyMethod;

    CORSConfigurationBuilder(PathConfigurationBuilder parentBuilder) {
        super(parentBuilder);
    }

    public CORSConfigurationBuilder allowOrigins(String ... allowedOrigins) {
        this.allowedOrigins.addAll(Arrays.asList(allowedOrigins));
        return this;
    }

    public CORSConfigurationBuilder allowMethods(String ... allowedMethods) {
        this.allowedMethods.addAll(Arrays.asList(allowedMethods));
        return this;
    }

    public CORSConfigurationBuilder allowHeaders(String ... allowedHeaders) {
        this.allowedHeaders.addAll(Arrays.asList(allowedHeaders));
        return this;
    }

    public CORSConfigurationBuilder exposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders.addAll(Arrays.asList(exposedHeaders));
        return this;
    }

    public CORSConfigurationBuilder allowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public CORSConfigurationBuilder allowAnyOrigin(boolean allowAnyOrigin) {
        this.allowAnyOrigin = allowAnyOrigin;
        return this;
    }

    public CORSConfigurationBuilder allowAnyHeader(boolean allowAnyHeader) {
        this.allowAnyHeader = allowAnyHeader;
        return this;
    }

    public CORSConfigurationBuilder allowAnyMethod(boolean allowAnyMethod) {
        this.allowAnyMethod = allowAnyMethod;
        return this;
    }

    public CORSConfigurationBuilder allowAll() {
        this.allowAnyHeader(true);
        this.allowAnyMethod(true);
        this.allowAnyOrigin(true);
        this.allowCredentials(true);
        return this;
    }

    public CORSConfigurationBuilder maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    CORSConfiguration create(PathConfiguration pathConfiguration) {
        return new CORSConfiguration(pathConfiguration, this.allowedOrigins, this.allowedMethods, this.allowedHeaders, this.exposedHeaders, this.allowCredentials, this.allowAnyOrigin, this.allowAnyHeader, this.allowAnyMethod, this.maxAge);
    }
}

