/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.util;

import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformerUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static TransformerFactory transformerFactory;

    public static Transformer getTransformer() throws ConfigurationException {
        Transformer transformer;
        try {
            transformer = TransformerUtil.getTransformerFactory().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw logger.configurationError(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw logger.configurationError(e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        return transformer;
    }

    private static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static Transformer getStaxSourceToDomResultTransformer() throws ConfigurationException {
        return new PicketLinkStaxToDOMTransformer();
    }

    public static void transform(Transformer transformer, StAXSource stax, DOMResult result) throws ParsingException {
        try {
            transformer.transform(stax, result);
        }
        catch (TransformerException e) {
            throw logger.parserError(e);
        }
    }

    public static void transform(JAXBContext context, JAXBElement<?> jaxb, Result result) throws ParsingException {
        try {
            Transformer transformer = TransformerUtil.getTransformer();
            JAXBSource jaxbSource = new JAXBSource(context, jaxb);
            transformer.transform((Source)jaxbSource, result);
        }
        catch (Exception e) {
            throw logger.parserError(e);
        }
    }

    private static class PicketLinkStaxToDOMTransformer
    extends Transformer {
        private PicketLinkStaxToDOMTransformer() {
        }

        @Override
        public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
            if (!(xmlSource instanceof StAXSource)) {
                throw logger.wrongTypeError("xmlSource should be a stax source");
            }
            if (!(outputTarget instanceof DOMResult)) {
                throw logger.wrongTypeError("outputTarget should be a dom result");
            }
            String rootTag = null;
            StAXSource staxSource = (StAXSource)xmlSource;
            XMLEventReader xmlEventReader = staxSource.getXMLEventReader();
            if (xmlEventReader == null) {
                throw new TransformerException(logger.nullValueError("XMLEventReader"));
            }
            DOMResult domResult = (DOMResult)outputTarget;
            Document doc = (Document)domResult.getNode();
            Stack<Node> stack = new Stack<Node>();
            try {
                XMLEvent xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                if (!(xmlEvent instanceof StartElement)) {
                    throw new TransformerException("PL00096: Writer: Should have been a StartElement");
                }
                StartElement rootElement = (StartElement)xmlEvent;
                rootTag = StaxParserUtil.getStartElementName(rootElement);
                Element docRoot = this.handleStartElement(xmlEventReader, rootElement, new CustomHolder(doc, false));
                Node parent = doc.importNode(docRoot, true);
                doc.appendChild(parent);
                stack.push(parent);
                while (xmlEventReader.hasNext()) {
                    xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                    int type = xmlEvent.getEventType();
                    switch (type) {
                        case 1: {
                            StartElement startElement = (StartElement)xmlEvent;
                            CustomHolder holder = new CustomHolder(doc, false);
                            Element docStartElement = this.handleStartElement(xmlEventReader, startElement, holder);
                            Node el = doc.importNode(docStartElement, true);
                            Node top = null;
                            if (!stack.isEmpty()) {
                                top = (Node)stack.peek();
                            }
                            if (!holder.encounteredTextNode) {
                                stack.push(el);
                            }
                            if (top == null) {
                                doc.appendChild(el);
                                break;
                            }
                            top.appendChild(el);
                            break;
                        }
                        case 2: {
                            EndElement endElement = (EndElement)xmlEvent;
                            String endTag = StaxParserUtil.getEndElementName(endElement);
                            if (rootTag.equals(endTag)) {
                                return;
                            }
                            if (stack.isEmpty()) break;
                            stack.pop();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }

        @Override
        public void setParameter(String name, Object value) {
        }

        @Override
        public Object getParameter(String name) {
            return null;
        }

        @Override
        public void clearParameters() {
        }

        @Override
        public void setURIResolver(URIResolver resolver) {
        }

        @Override
        public URIResolver getURIResolver() {
            return null;
        }

        @Override
        public void setOutputProperties(Properties oformat) {
        }

        @Override
        public Properties getOutputProperties() {
            return null;
        }

        @Override
        public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        }

        @Override
        public String getOutputProperty(String name) throws IllegalArgumentException {
            return null;
        }

        @Override
        public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        }

        @Override
        public ErrorListener getErrorListener() {
            return null;
        }

        private Element handleStartElement(XMLEventReader xmlEventReader, StartElement startElement, CustomHolder holder) throws ParsingException, ProcessingException {
            Characters characterEvent;
            String trimmedData;
            Document doc = holder.doc;
            QName elementName = startElement.getName();
            String ns = elementName.getNamespaceURI();
            String prefix = elementName.getPrefix();
            String localPart = elementName.getLocalPart();
            String qual = prefix != null && prefix != "" ? prefix + ":" + localPart : localPart;
            Element el = doc.createElementNS(ns, qual);
            String containsBaseNamespace = this.containsBaseNamespace(startElement);
            if (StringUtil.isNotNull(containsBaseNamespace)) {
                el = DocumentUtil.createDocumentWithBaseNamespace(containsBaseNamespace, localPart).getDocumentElement();
                el = (Element)doc.importNode(el, true);
            }
            if (StringUtil.isNotNull(prefix)) {
                el.setPrefix(prefix);
            }
            Iterator<Attribute> attrs = startElement.getAttributes();
            while (attrs != null && attrs.hasNext()) {
                Attribute attr = attrs.next();
                QName attrName = attr.getName();
                ns = attrName.getNamespaceURI();
                prefix = attrName.getPrefix();
                localPart = attrName.getLocalPart();
                String string = qual = prefix != null && prefix != "" ? prefix + ":" + localPart : localPart;
                if (logger.isTraceEnabled()) {
                    logger.trace("Creating an Attribute Namespace=" + ns + ":" + qual);
                }
                doc.createAttributeNS(ns, qual);
                el.setAttributeNS(ns, qual, attr.getValue());
            }
            Iterator<Namespace> namespaces = startElement.getNamespaces();
            while (namespaces != null && namespaces.hasNext()) {
                Namespace namespace = namespaces.next();
                QName name = namespace.getName();
                localPart = name.getLocalPart();
                prefix = name.getPrefix();
                if (prefix != null && prefix != "") {
                    String string = qual = localPart != null && localPart != "" ? prefix + ":" + localPart : prefix;
                }
                if (qual.equals("xmlns")) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Set Attribute Namespace=" + name.getNamespaceURI() + "::Qual=:" + qual + "::Value=" + namespace.getNamespaceURI());
                }
                if (qual == null || !qual.startsWith("xmlns")) continue;
                el.setAttributeNS(name.getNamespaceURI(), qual, namespace.getNamespaceURI());
            }
            XMLEvent nextEvent = StaxParserUtil.peek(xmlEventReader);
            if (nextEvent instanceof Comment) {
                Comment commentEvent = (Comment)nextEvent;
                Node commentNode = doc.createComment(commentEvent.getText());
                commentNode = doc.importNode(commentNode, true);
                el.appendChild(commentNode);
            } else if (nextEvent.getEventType() == 4 && (trimmedData = (characterEvent = (Characters)nextEvent).getData().trim()) != null && trimmedData.length() > 0) {
                holder.encounteredTextNode = true;
                try {
                    String text = StaxParserUtil.getElementText(xmlEventReader);
                    Node textNode = doc.createTextNode(text);
                    textNode = doc.importNode(textNode, true);
                    el.appendChild(textNode);
                }
                catch (Exception e) {
                    throw logger.parserException(e);
                }
            }
            return el;
        }

        private String containsBaseNamespace(StartElement startElement) {
            String qual = null;
            Iterator<Namespace> namespaces = startElement.getNamespaces();
            while (namespaces != null && namespaces.hasNext()) {
                Namespace namespace = namespaces.next();
                QName name = namespace.getName();
                String localPart = name.getLocalPart();
                String prefix = name.getPrefix();
                if (prefix != null && prefix != "") {
                    String string = qual = localPart != null && localPart != "" ? prefix + ":" + localPart : prefix;
                }
                if (qual == null || !qual.equals("xmlns")) continue;
                return namespace.getNamespaceURI();
            }
            return null;
        }

        private class CustomHolder {
            public Document doc;
            public boolean encounteredTextNode = false;

            public CustomHolder(Document document, boolean bool) {
                this.doc = document;
                this.encounteredTextNode = bool;
            }
        }
    }
}

