/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.parsers;

import java.io.InputStream;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;

public abstract class AbstractParser
implements ParserNamespaceSupport {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public Object parse(InputStream configStream) throws ParsingException {
        if (configStream == null) {
            throw logger.nullArgumentError("InputStream");
        }
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(configStream);
        try {
            xmlEventReader = xmlInputFactory.createFilteredReader(xmlEventReader, new EventFilter(){

                @Override
                public boolean accept(XMLEvent xmlEvent) {
                    if (xmlEvent.isCharacters()) {
                        Characters chars = xmlEvent.asCharacters();
                        String data = chars.getData();
                        data = this.valid(data) ? data.trim() : null;
                        return this.valid(data);
                    }
                    return xmlEvent.isStartElement() || xmlEvent.isEndElement();
                }

                private boolean valid(String str) {
                    return str != null && str.length() > 0;
                }
            });
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return this.parse(xmlEventReader);
    }
}

