/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.sig;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathException;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.transfer.SignatureUtilTransferObject;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAML2Signature {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final String ID_ATTRIBUTE_NAME = "ID";
    private String signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
    private Node sibling;
    private X509Certificate x509Certificate;

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public void setNextSibling(Node sibling) {
        this.sibling = sibling;
    }

    public void setSignatureIncludeKeyInfo(boolean val) {
        if (!val) {
            XMLSignatureUtil.setIncludeKeyInfoInSignature(false);
        }
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    public Document sign(RequestAbstractType request, KeyPair keypair) throws SAXException, IOException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Request saml2Request = new SAML2Request();
        Document doc = saml2Request.convert(request);
        doc.normalize();
        Node theSibling = this.getNextSiblingOfIssuer(doc);
        if (theSibling != null) {
            this.sibling = theSibling;
        }
        return this.sign(doc, request.getID(), keypair);
    }

    public Document sign(ResponseType response, KeyPair keypair) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Request = new SAML2Response();
        Document doc = saml2Request.convert(response);
        doc.normalize();
        Node theSibling = this.getNextSiblingOfIssuer(doc);
        if (theSibling != null) {
            this.sibling = theSibling;
        }
        return this.sign(doc, response.getID(), keypair);
    }

    public Document sign(Document doc, String referenceID, KeyPair keyPair) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        String referenceURI = "#" + referenceID;
        this.configureIdAttribute(doc);
        if (this.sibling != null) {
            SignatureUtilTransferObject dto = new SignatureUtilTransferObject();
            dto.setDocumentToBeSigned(doc);
            dto.setKeyPair(keyPair);
            dto.setDigestMethod(this.digestMethod);
            dto.setSignatureMethod(this.signatureMethod);
            dto.setReferenceURI(referenceURI);
            dto.setNextSibling(this.sibling);
            if (this.x509Certificate != null) {
                dto.setX509Certificate(this.x509Certificate);
            }
            return XMLSignatureUtil.sign(dto);
        }
        return XMLSignatureUtil.sign(doc, keyPair, this.digestMethod, this.signatureMethod, referenceURI);
    }

    public Document sign(ResponseType response, String idValueOfAssertion, KeyPair keypair, String referenceURI) throws ParserConfigurationException, XPathException, TransformerFactoryConfigurationError, TransformerException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Response = new SAML2Response();
        Document doc = saml2Response.convert(response);
        doc.normalize();
        Node theSibling = this.getNextSiblingOfIssuer(doc);
        if (theSibling != null) {
            this.sibling = theSibling;
        }
        return this.sign(doc, idValueOfAssertion, keypair, referenceURI);
    }

    public Document sign(Document doc, String idValueOfAssertion, KeyPair keypair, String referenceURI) throws ParserConfigurationException, XPathException, TransformerFactoryConfigurationError, TransformerException, GeneralSecurityException, MarshalException, XMLSignatureException {
        return this.sign(doc, idValueOfAssertion, keypair);
    }

    public void signSAMLDocument(Document samlDocument, KeyPair keypair) throws ProcessingException {
        String id = samlDocument.getDocumentElement().getAttribute(ID_ATTRIBUTE_NAME);
        try {
            this.sign(samlDocument, id, keypair);
        }
        catch (Exception e) {
            throw new ProcessingException(logger.signatureError(e));
        }
    }

    public boolean validate(Document signedDocument, PublicKey publicKey) throws ProcessingException {
        try {
            this.configureIdAttribute(signedDocument);
            return XMLSignatureUtil.validate(signedDocument, publicKey);
        }
        catch (MarshalException me) {
            throw new ProcessingException(logger.signatureError(me));
        }
        catch (XMLSignatureException xse) {
            throw new ProcessingException(logger.signatureError(xse));
        }
    }

    private void configureIdAttribute(Document document) {
        document.getDocumentElement().setIdAttribute(ID_ATTRIBUTE_NAME, true);
        NodeList nodes = document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            ((Element)n).setIdAttribute(ID_ATTRIBUTE_NAME, true);
        }
    }

    public Node getNextSiblingOfIssuer(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get());
        if (nl.getLength() > 0) {
            Node issuer = nl.item(0);
            return issuer.getNextSibling();
        }
        return null;
    }
}

