/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLStatusResponseTypeParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;

public class SAMLSloResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.LOGOUT_RESPONSE.get());
        StatusResponseType response = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText(xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.bypassElementBlock(xmlEventReader, JBossSAMLConstants.SIGNATURE.get());
                continue;
            }
            if (!JBossSAMLConstants.STATUS.get().equals(elementName)) continue;
            response.setStatus(this.parseStatus(xmlEventReader));
        }
        return response;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && JBossSAMLConstants.LOGOUT_RESPONSE.equals(qname.getLocalPart());
    }
}

