/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;

public class WSTCancelTargetParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        CancelTargetType cancelTarget = new CancelTargetType();
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        if (startElement == null) {
            throw logger.parserUnableParsingNullToken();
        }
        try {
            cancelTarget.add(StaxParserUtil.getDOMElement(xmlEventReader));
        }
        catch (Exception e) {
            throw logger.parserError(e);
        }
        return cancelTarget;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "CancelTarget".equals(localPart);
    }
}

