/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wsse.WSSecurityParser;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSTrustOnBehalfOfParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        OnBehalfOfType onBehalfType = new OnBehalfOfType();
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        String tag = StaxParserUtil.getStartElementName(startElement);
        if (!tag.equals("UsernameToken")) {
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        WSSecurityParser wsseParser = new WSSecurityParser();
        UsernameTokenType userNameToken = (UsernameTokenType)wsseParser.parse(xmlEventReader);
        onBehalfType.add(userNameToken);
        return onBehalfType;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(nsURI) && "OnBehalfOf".equals(localPart);
    }
}

