/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ConditionsType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;

public class SAML11ProtocolContext
implements ProtocolContext {
    protected String issuerID;
    protected SAML11SubjectType subjectType;
    protected SAML11ConditionsType conditions;
    protected List<SAML11StatementAbstractType> statements = new ArrayList<SAML11StatementAbstractType>();
    protected SAML11AssertionType issuedAssertion;
    protected String authMethod = "urn:oasis:names:tc:SAML:1.0:am:password";

    public String getIssuerID() {
        return this.issuerID;
    }

    public void setIssuerID(String issuerID) {
        this.issuerID = issuerID;
    }

    public SAML11SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SAML11SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public SAML11ConditionsType getConditions() {
        return this.conditions;
    }

    public void setConditions(SAML11ConditionsType conditions) {
        this.conditions = conditions;
    }

    public List<SAML11StatementAbstractType> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public void setStatements(List<SAML11StatementAbstractType> statements) {
        this.statements = statements;
    }

    public SAML11AssertionType getIssuedAssertion() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        return this.issuedAssertion;
    }

    public void setIssuedAssertion(SAML11AssertionType issuedAssertion) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.issuedAssertion = issuedAssertion;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Override
    public String serviceName() {
        return null;
    }

    @Override
    public String tokenType() {
        return "urn:oasis:names:tc:SAML:1.0:assertion";
    }

    @Override
    public QName getQName() {
        String localPart = JBossSAMLConstants.ASSERTION.get();
        String ns = this.tokenType();
        return new QName(ns, localPart);
    }

    @Override
    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.SAML11.toString();
    }
}

