/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaxUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static ThreadLocal<Stack<String>> registeredNSStack = new ThreadLocal();

    public static void flush(XMLStreamWriter writer) throws ProcessingException {
        try {
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static XMLEventWriter getXMLEventWriter(OutputStream outStream) throws ProcessingException {
        XMLOutputFactory xmlOutputFactory = StaxUtil.getXMLOutputFactory();
        try {
            return xmlOutputFactory.createXMLEventWriter(outStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static XMLStreamWriter getXMLStreamWriter(OutputStream outStream) throws ProcessingException {
        XMLOutputFactory xmlOutputFactory = StaxUtil.getXMLOutputFactory();
        try {
            return xmlOutputFactory.createXMLStreamWriter(outStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static XMLStreamWriter getXMLStreamWriter(Writer writer) throws ProcessingException {
        XMLOutputFactory xmlOutputFactory = StaxUtil.getXMLOutputFactory();
        try {
            return xmlOutputFactory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static XMLStreamWriter getXMLStreamWriter(Result result) throws ProcessingException {
        XMLOutputFactory factory = StaxUtil.getXMLOutputFactory();
        try {
            return factory.createXMLStreamWriter(result);
        }
        catch (XMLStreamException xe) {
            throw logger.processingError(xe);
        }
    }

    public static void setPrefix(XMLStreamWriter writer, String prefix, String nsURI) throws ProcessingException {
        try {
            writer.setPrefix(prefix, nsURI);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, QName attributeValue) throws ProcessingException {
        StaxUtil.writeAttribute(writer, attributeName, attributeValue.toString());
    }

    public static void writeAttribute(XMLStreamWriter writer, QName attributeName, String attributeValue) throws ProcessingException {
        try {
            writer.writeAttribute(attributeName.getPrefix(), attributeName.getNamespaceURI(), attributeName.getLocalPart(), attributeValue);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String localName, String value) throws ProcessingException {
        try {
            writer.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String localName, String type, String value) throws ProcessingException {
        try {
            writer.writeAttribute(localName, type, value);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String prefix, String localName, String type, String value) throws ProcessingException {
        try {
            writer.writeAttribute(prefix, localName, type, value);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeCharacters(XMLStreamWriter writer, String value) throws ProcessingException {
        try {
            writer.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeCData(XMLStreamWriter writer, String value) throws ProcessingException {
        try {
            writer.writeCData(value);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeDefaultNameSpace(XMLStreamWriter writer, String ns) throws ProcessingException {
        try {
            writer.writeDefaultNamespace(ns);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeDOMNode(XMLStreamWriter writer, Node node) throws ProcessingException {
        try {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 1: {
                    StaxUtil.writeDOMElement(writer, (Element)node);
                    break;
                }
                case 3: {
                    writer.writeCharacters(node.getNodeValue());
                    break;
                }
                case 8: {
                    writer.writeComment(node.getNodeValue());
                    break;
                }
                case 4: {
                    writer.writeCData(node.getNodeValue());
                    break;
                }
            }
        }
        catch (DOMException e) {
            throw logger.processingError(e);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeDOMElement(XMLStreamWriter writer, Element domElement) throws ProcessingException {
        String domElementNS;
        String domElementPrefix;
        if (registeredNSStack.get() == null) {
            registeredNSStack.set(new Stack());
        }
        if ((domElementPrefix = domElement.getPrefix()) == null) {
            domElementPrefix = "";
        }
        if ((domElementNS = domElement.getNamespaceURI()) == null) {
            domElementNS = "";
        }
        StaxUtil.writeStartElement(writer, domElementPrefix, domElement.getLocalName(), domElementNS);
        if (domElementPrefix != "" && !registeredNSStack.get().contains(domElementNS)) {
            registeredNSStack.get().push(domElementNS);
        } else if (domElementPrefix == "" && domElementNS != null) {
            StaxUtil.writeNameSpace(writer, "xmlns", domElementNS);
        }
        NamedNodeMap attrs = domElement.getAttributes();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String attributePrefix = attr.getPrefix();
            String attribLocalName = attr.getLocalName();
            String attribValue = attr.getValue();
            if (attributePrefix == null || attributePrefix.length() == 0) {
                if ("xmlns".equals(attribLocalName)) continue;
                StaxUtil.writeAttribute(writer, attribLocalName, attribValue);
                continue;
            }
            if ("xmlns".equals(attributePrefix)) {
                StaxUtil.writeNameSpace(writer, attribLocalName, attribValue);
                continue;
            }
            StaxUtil.writeAttribute(writer, new QName(attr.getNamespaceURI(), attribLocalName, attributePrefix), attribValue);
        }
        for (Node child = domElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            StaxUtil.writeDOMNode(writer, child);
        }
        StaxUtil.writeEndElement(writer);
    }

    public static void writeNameSpace(XMLStreamWriter writer, String prefix, String ns) throws ProcessingException {
        try {
            writer.writeNamespace(prefix, ns);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String prefix, String localPart, String ns) throws ProcessingException {
        try {
            writer.writeStartElement(prefix, localPart, ns);
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeEndElement(XMLStreamWriter writer) throws ProcessingException {
        try {
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw logger.processingError(e);
        }
    }

    public static void writeKeyInfo(XMLStreamWriter writer, KeyInfoType keyInfo) throws ProcessingException {
        if (keyInfo.getContent() == null || keyInfo.getContent().size() == 0) {
            throw logger.writerInvalidKeyInfoNullContentError();
        }
        StaxUtil.writeStartElement(writer, "ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeNameSpace(writer, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Object content = keyInfo.getContent().get(0);
        if (content instanceof Element) {
            Element element = (Element)keyInfo.getContent().get(0);
            StaxUtil.writeDOMNode(writer, element);
        } else if (content instanceof X509DataType) {
            X509DataType type = (X509DataType)content;
            if (type.getDataObjects().size() == 0) {
                throw logger.writerNullValueError("X509Data");
            }
            StaxUtil.writeStartElement(writer, "ds", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            Object obj = type.getDataObjects().get(0);
            if (obj instanceof Element) {
                Element element = (Element)obj;
                StaxUtil.writeDOMElement(writer, element);
            } else if (obj instanceof X509CertificateType) {
                X509CertificateType cert = (X509CertificateType)obj;
                StaxUtil.writeStartElement(writer, "ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeCharacters(writer, new String(cert.getEncodedCertificate()));
                StaxUtil.writeEndElement(writer);
            }
            StaxUtil.writeEndElement(writer);
        } else if (content instanceof KeyValueType) {
            KeyValueType keyvalueType = (KeyValueType)content;
            StaxUtil.writeStartElement(writer, "ds", "KeyValue", "http://www.w3.org/2000/09/xmldsig#");
            if (keyvalueType instanceof DSAKeyValueType) {
                StaxUtil.writeDSAKeyValueType(writer, (DSAKeyValueType)keyvalueType);
            }
            if (keyvalueType instanceof RSAKeyValueType) {
                StaxUtil.writeRSAKeyValueType(writer, (RSAKeyValueType)keyvalueType);
            }
            StaxUtil.writeEndElement(writer);
        } else {
            throw new ProcessingException("PL00069: Parser: Type not supported:" + content);
        }
        StaxUtil.writeEndElement(writer);
    }

    public static void writeRSAKeyValueType(XMLStreamWriter writer, RSAKeyValueType type) throws ProcessingException {
        String prefix = "ds";
        StaxUtil.writeStartElement(writer, prefix, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
        byte[] modulus = type.getModulus();
        StaxUtil.writeStartElement(writer, prefix, "Modulus", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(writer, new String(modulus));
        StaxUtil.writeEndElement(writer);
        byte[] exponent = type.getExponent();
        StaxUtil.writeStartElement(writer, prefix, "Exponent", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(writer, new String(exponent));
        StaxUtil.writeEndElement(writer);
        StaxUtil.writeEndElement(writer);
    }

    public static void writeDSAKeyValueType(XMLStreamWriter writer, DSAKeyValueType type) throws ProcessingException {
        byte[] pgen;
        byte[] seed;
        byte[] y;
        byte[] g;
        byte[] q;
        String prefix = "ds";
        StaxUtil.writeStartElement(writer, prefix, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
        byte[] p = type.getP();
        if (p != null) {
            StaxUtil.writeStartElement(writer, prefix, "P", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(p));
            StaxUtil.writeEndElement(writer);
        }
        if ((q = type.getQ()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Q", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(q));
            StaxUtil.writeEndElement(writer);
        }
        if ((g = type.getG()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "G", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(g));
            StaxUtil.writeEndElement(writer);
        }
        if ((y = type.getY()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Y", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(y));
            StaxUtil.writeEndElement(writer);
        }
        if ((seed = type.getSeed()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Seed", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(seed));
            StaxUtil.writeEndElement(writer);
        }
        if ((pgen = type.getPgenCounter()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "PgenCounter", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(pgen));
            StaxUtil.writeEndElement(writer);
        }
        StaxUtil.writeEndElement(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLOutputFactory getXMLOutputFactory() {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(StaxUtil.class.getClassLoader());
            }
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            return xMLOutputFactory;
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
    }
}

